/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.JobDep;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class VariableDepMsgReporter {
    public static final String MISSING_VARIABLE_NAME_HEADER = "missing variable name";
    public static final String NON_EXISTING_VARIABLE = "non-existing variable";
    private Function<Integer, AttrHolderList> varmstRecordGetter;
    private BiConsumer<Integer, List<String>> jobMessagesUpdater;

    public VariableDepMsgReporter(Function<Integer, AttrHolderList> varmstRecordsGetter, BiConsumer<Integer, List<String>> msgUpdater) {
        this.varmstRecordGetter = varmstRecordsGetter;
        this.jobMessagesUpdater = msgUpdater;
    }

    List<String> getParametersList(String jobName, JobDep dep) {
        ArrayList<String> messageParametersList = new ArrayList<String>();
        messageParametersList.add("WRN1012");
        Integer dependantVariableId = dep.getAttrAsInt("VARMST_ID");
        AttrHolderList var_list = this.varmstRecordGetter.apply(dependantVariableId);
        String variableName = NON_EXISTING_VARIABLE;
        if (var_list != null) {
            for (IAttrHolder var : var_list) {
                variableName = var.getAttr("VARMST_NAME");
                if (null != variableName) continue;
                variableName = MISSING_VARIABLE_NAME_HEADER;
            }
        }
        messageParametersList.add(variableName);
        messageParametersList.add(dependantVariableId == null ? "0" : dependantVariableId.toString());
        messageParametersList.add(jobName);
        return messageParametersList;
    }

    public void reportVarDepMessage(String ctmJobname, JobDep dep, int jobId) {
        List<String> messageParametersList = this.getParametersList(ctmJobname, dep);
        this.jobMessagesUpdater.accept(jobId, messageParametersList);
    }
}

