/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.ondo.DoMail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TidalDoMail {
    private static final String TSKMAIL_SUBJECT = "TSKMAIL_SUBJECT";
    private static final int MAX_MESSAGE_LENGTH = 255;
    private DoMail doMail;
    private Map<String, List<String>> messages = new LinkedHashMap<String, List<String>>();
    private IAttrHolder mailDetails;
    private RecordGetter userGetter = (x, y) -> null;
    private TidalVariableExpander tidalVarExpander = x -> x;
    private int tsk_id;
    private String tskmail_subject;
    private String tskmail_to_int;
    private String tskmail_to_ext;
    private String tskmail_memo;

    public TidalDoMail(IAttrHolder inputMailDetails, RecordGetter inputUserGetter, TidalVariableExpander expander, int tsk_id) {
        this.tsk_id = tsk_id;
        this.mailDetails = inputMailDetails;
        if (inputUserGetter != null) {
            this.userGetter = inputUserGetter;
        }
        if (expander != null) {
            this.tidalVarExpander = expander;
        }
        this.init();
    }

    private void init() {
        this.tskmail_subject = this.mailDetails.getAttr(TSKMAIL_SUBJECT);
        this.tskmail_to_int = this.mailDetails.getAttr("TSKMAIL_TO_INT");
        this.tskmail_to_ext = this.mailDetails.getAttr("TSKMAIL_TO_EXT");
        this.tskmail_memo = this.mailDetails.getAttr("TSKMAIL_MEMO");
    }

    private void validateAndIssueMessages() {
        this.issueEmailDestinationMeessages();
    }

    private void setDoMailProperties() {
        this.doMail = new DoMail(new String[]{this.calculateEmailDestination()});
        String mailSubjectCTMVariableFormat = (String)this.tidalVarExpander.apply(this.tskmail_subject);
        this.doMail.setSubject(mailSubjectCTMVariableFormat);
        this.doMail.setMessage(this.calculateEmailMessage());
        this.doMail.setAttachSysout(DoMail.AttachSysout.NO);
        this.doMail.setUrgancy("R");
    }

    private void updateMessages(String key, String ... value) {
        List<String> messageArgsList = this.messages.get(key);
        if (messageArgsList == null) {
            messageArgsList = new ArrayList<String>();
            this.messages.put(key, messageArgsList);
        }
        messageArgsList.addAll(Arrays.asList(value));
    }

    private void issueEmailDestinationMeessages() {
        String detailedMsg;
        String externalMailAddress;
        String internalMailAddress = (String)this.tidalVarExpander.apply(this.tskmail_to_int);
        if ((internalMailAddress + (externalMailAddress = (String)this.tidalVarExpander.apply(this.tskmail_to_ext))).isEmpty()) {
            detailedMsg = "Missing email address for DOMAIL action. TaskID - " + this.tsk_id + ". Using default email address - DEFAULT@DEFAULT.COM";
            this.updateMessages("INF2011", detailedMsg);
        }
        if (internalMailAddress != null && !internalMailAddress.equals("")) {
            if (internalMailAddress.startsWith("<")) {
                detailedMsg = "Could not resolve email address for DOMAIL action for taskID - " + this.tsk_id;
                this.updateMessages("INF2009", detailedMsg);
            } else if (this.isUserIdsFormat(internalMailAddress)) {
                String[] userIdsArray;
                internalMailAddress = internalMailAddress.replaceAll("(^[\"]|[\"]$)", "");
                for (String userId : userIdsArray = internalMailAddress.split("\\s*?,\\s*?")) {
                    int userID = Integer.valueOf(userId);
                    IAttrHolder user_rec = (IAttrHolder)this.userGetter.apply("USRMST", userID);
                    if (user_rec == null) {
                        String detailedMsg2 = "No email address defined for userID - " + userID;
                        this.updateMessages("INF2010", detailedMsg2);
                        continue;
                    }
                    String userMailAddress = user_rec.getAttr("USRMST_EMAIL");
                    if (userMailAddress != null) continue;
                    String detailedMsg3 = "No email address defined for userID - " + userID;
                    this.updateMessages("INF2010", detailedMsg3);
                }
            } else {
                this.updateMessages("INF2010", "");
            }
        }
    }

    private String calculateEmailDestination() {
        StringBuilder sb = new StringBuilder();
        String internalMailAddress = (String)this.tidalVarExpander.apply(this.tskmail_to_int);
        String externalMailAddress = (String)this.tidalVarExpander.apply(this.tskmail_to_ext);
        String mailAddress = "";
        if (externalMailAddress != null) {
            sb.append(externalMailAddress);
        }
        if (internalMailAddress != null) {
            if (internalMailAddress.startsWith("<")) {
                sb.append(internalMailAddress + "@DEFAULT.COM");
            } else if (this.isUserIdsFormat(internalMailAddress)) {
                String[] userIdsArray;
                internalMailAddress = internalMailAddress.replaceAll("(^[\"]|[\"]$)", "");
                for (String userId : userIdsArray = internalMailAddress.split("\\s*?,\\s*?")) {
                    String userMailAddress;
                    int userID = Integer.valueOf(userId);
                    IAttrHolder user_rec = (IAttrHolder)this.userGetter.apply("USRMST", userID);
                    if (user_rec == null || (userMailAddress = user_rec.getAttr("USRMST_EMAIL")) == null) continue;
                    if (sb.length() > 0) {
                        sb.append(";" + userMailAddress);
                        continue;
                    }
                    sb.append(userMailAddress);
                }
            }
        }
        if ((mailAddress = sb.toString()).isEmpty()) {
            mailAddress = "DEFAULT@DEFAULT.COM";
        }
        return mailAddress;
    }

    private String calculateEmailMessage() {
        String message = (String)this.tidalVarExpander.apply(this.tskmail_memo);
        if (message.length() > 255) {
            message = message.substring(0, 254);
        }
        return message;
    }

    private boolean isUserIdsFormat(String internalMailAddress) {
        return internalMailAddress.matches("[\"]?(\\d[,]?)+[\"]?");
    }

    public LinkedHashMap<String, List<String>> getMessages() {
        this.validateAndIssueMessages();
        return new LinkedHashMap<String, List<String>>(this.messages);
    }

    public Properties getDoMailProperties() {
        this.setDoMailProperties();
        return this.doMail.getProperties();
    }

    public static interface RecordGetter
    extends BiFunction<String, Integer, IAttrHolder> {
    }

    public static interface TidalVariableExpander
    extends Function<String, String> {
    }
}

