/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.tidal.CognosConverter;
import com.bmc.ctmconvert.tidal.InformaticaCloudCSConvertor;
import com.bmc.ctmconvert.tidal.JDBCConvertor;
import com.bmc.ctmconvert.tidal.TidalAS400Convertor;
import com.bmc.ctmconvert.tidal.TidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalDBMSSQLfactory;
import com.bmc.ctmconvert.tidal.TidalInformaticaConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import com.bmc.ctmconvert.tidal.TidalOEBSFactory;
import com.bmc.ctmconvert.tidal.TidalWebServicefactory;
import com.bmc.ctmconvert.tidal.UnsupportedAdapterConvertor;
import com.bmc.ctmconvert.tidal.ftp.TidalFTPConvertor;
import com.bmc.ctmconvert.tidal.sap.TidalSAPfactory;
import java.util.Objects;
import java.util.Optional;

public class TidalCmsManager {
    private final RecordsHolder jobMst;
    private final RecordsHolder jobDtl;
    private final RecordsHolder serviceMst;
    public static final int JOBMST_TYPE_ADAPTER = 8;
    public static final int JOBMST_TYPE_FTP = 6;
    public static final int JOBMST_TYPE_AS400 = 7;

    public TidalCmsManager(RecordsHolder jobMst, RecordsHolder jobDtl, RecordsHolder serviceMst) {
        this.jobMst = jobMst;
        this.jobDtl = jobDtl;
        this.serviceMst = serviceMst;
    }

    public TidalCmConvertor getConvertor(TidalJob job) {
        int jobMstId = job.getJobID();
        if (this.isAS400Job(job.getJobID())) {
            return new TidalAS400Convertor(job);
        }
        if (this.isInformaticaJob(jobMstId)) {
            return new TidalInformaticaConvertor();
        }
        if (this.isSAPJob(jobMstId)) {
            TidalSAPfactory convertor = new TidalSAPfactory();
            return convertor.getConvertor(jobMstId, job.getJobdtlRec());
        }
        if (this.isFTPJob(jobMstId)) {
            return new TidalFTPConvertor(job);
        }
        if (this.isMSSQLJob(jobMstId)) {
            TidalDBMSSQLfactory convertor = new TidalDBMSSQLfactory(job);
            return convertor.getConvertor(jobMstId, job.getJobdtlRec());
        }
        if (this.isWebServiceJob(jobMstId)) {
            TidalWebServicefactory convertor = new TidalWebServicefactory();
            return convertor.getConvertor(jobMstId, job.getJobdtlRec());
        }
        if (this.isOEBSJob(jobMstId)) {
            TidalOEBSFactory convertor = new TidalOEBSFactory();
            return convertor.getConvertor(jobMstId, job);
        }
        if (this.isJDBCJob(jobMstId)) {
            return new JDBCConvertor(job);
        }
        if (this.isInformaticaCSJob(jobMstId)) {
            return new InformaticaCloudCSConvertor(job);
        }
        if (this.isCognosJob(jobMstId)) {
            return new CognosConverter(job);
        }
        String serviceName = this.getServiceName(jobMstId);
        job.addMessage("WRN2339", job.getOriginalJobName(), job.getJobName(), serviceName);
        return new UnsupportedAdapterConvertor();
    }

    private boolean isAS400Job(int jobID) {
        Integer jobmstType = this.jobMst.get(jobID).getAttrAsInt("JOBMST_TYPE");
        return 7 == jobmstType;
    }

    private boolean isCognosJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "Cognos");
    }

    private boolean isOEBSJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "OracleApps");
    }

    private boolean isSAPJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "sap");
    }

    private boolean isFTPJob(int jobMstId) {
        return this.jobMst.get(jobMstId).getAttrAsInt("JOBMST_TYPE") == 6;
    }

    private boolean isInformaticaJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "informatica");
    }

    private boolean isJDBCJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "JDBC");
    }

    private boolean isInformaticaCSJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "IICS");
    }

    private boolean isMSSQLJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "MSSql");
    }

    private boolean isWebServiceJob(int jobMstId) {
        return this.checkServiceNameEquals(jobMstId, "WebService");
    }

    private boolean checkServiceNameEquals(int jobMstId, String adapterName) {
        boolean toRet = false;
        if (this.serviceMst != null && !this.serviceMst.getAllRecords().isEmpty()) {
            String serviceName = this.getServiceName(jobMstId);
            toRet = !Objects.equals(serviceName, "") && serviceName.equalsIgnoreCase(adapterName);
        }
        return toRet;
    }

    private String getServiceName(int jobMstId) {
        int jobDtlId = this.jobMst.get(jobMstId).getAttrAsInt("JOBDTL_ID");
        Optional<Integer> serviceMstId = Optional.ofNullable(this.jobDtl.get(jobDtlId)).map(x -> x.getAttrAsInt("SERVICEMST_ID"));
        return serviceMstId.filter(id -> this.serviceMst.get(id.intValue()) != null).map(id -> this.serviceMst.get(id.intValue()).getAttr("SERVICEMST_NAME")).orElse("");
    }

    public boolean isAdapterJob(int jobMstId) {
        Integer jobmstType = this.jobMst.get(jobMstId).getAttrAsInt("JOBMST_TYPE");
        return jobmstType == 8 || jobmstType == 6 || jobmstType == 7;
    }
}

