/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.EmptyAttrHolder;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.tidal.RbcFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RbcRetriever {
    private static final int JOBMST_TYPE_GROUP = 1;
    private static final String NEVER_RUN_TAG = "NEVER_RUN_TAG";
    private static final Integer UNDEFINED_CALENDAR = 0;
    private RecordsHolder evntMstTable;
    private RecordsHolder evntYearTable;
    private RecordsHolder evntConditionTable;
    private RecordsHolder evntChildTable;
    private RecordsHolder jobMstTable;
    private RecordsHolder jobDtlTable;
    private Function<Integer, List<IAttrHolder>> childRetriever;

    public RbcRetriever(RecordsHolder evntMstTable, RecordsHolder jobMstTable, RecordsHolder jobDtlTable, RecordsHolder evntYearTable, RecordsHolder evntChildTable, RecordsHolder evntConditionTable, Function<Integer, List<IAttrHolder>> childRetriever) {
        this.evntMstTable = evntMstTable;
        this.jobDtlTable = jobDtlTable;
        this.jobMstTable = jobMstTable;
        this.evntYearTable = evntYearTable;
        this.evntChildTable = evntChildTable;
        this.evntConditionTable = evntConditionTable;
        this.childRetriever = childRetriever;
    }

    public Set<RBC> getRbcsFor(int jobMstId) {
        LinkedHashSet<RBC> retSet = new LinkedHashSet<RBC>();
        IAttrHolder jobMstRecord = this.jobMstTable.get(jobMstId);
        int evntMstId = jobMstRecord.getAttrAsInt("EVNTMST_ID");
        if (this.isDentifiedEvent(evntMstId)) {
            this.validateEventExistInEventTable(jobMstRecord, evntMstId);
            List<RBC> rbc = new RbcFactory(this::getEvntGroupChildren, this::getEventYearListByID, this::getEventConditionsListByID, this::getEventMstByID).generateRbcs(this.evntMstTable.get(evntMstId));
            retSet.addAll(rbc);
        } else if (this.isCalendarInherited(jobMstRecord)) {
            retSet.addAll(this.inheritRbcFromAncestor(jobMstRecord));
        } else if (jobMstRecord.getAttrAsInt("JOBMST_TYPE").equals(1)) {
            retSet.add(new RBC(NEVER_RUN_TAG));
        }
        if (this.isInactiveSub(jobMstRecord)) {
            retSet.add(new RBC(NEVER_RUN_TAG));
        }
        retSet.addAll(this.getAllDecsendantsRBCs(jobMstId));
        return retSet;
    }

    private IAttrHolder getEventMstByID(int evntMstId) {
        return this.evntMstTable.getAllRecords().stream().filter(rec -> rec.getAttrAsInt("EVNTMST_ID") == evntMstId).findFirst().orElse((IAttrHolder)new EmptyAttrHolder());
    }

    private List<IAttrHolder> getEventConditionsListByID(int evntMstId) {
        return this.evntConditionTable.getAllRecords().stream().filter(rec -> rec.getAttrAsInt("EVNTMST_ID") == evntMstId).collect(Collectors.toList());
    }

    private List<IAttrHolder> getEventYearListByID(int evntMstId) {
        return this.evntYearTable.getAllRecords().stream().filter(rec -> rec.getAttrAsInt("EVNTMST_ID") == evntMstId).collect(Collectors.toList());
    }

    private boolean isInactiveSub(IAttrHolder jobMstRecord) {
        return !jobMstRecord.getAttr("JOBMST_ACTIVE").equals("Y") && jobMstRecord.getAttrAsInt("JOBMST_PRNTID") > 0 && jobMstRecord.getAttrAsInt("JOBMST_TYPE").equals(1);
    }

    private Collection<? extends RBC> getAllDecsendantsRBCs(int jobMstId) {
        LinkedHashSet<RBC> retSet = new LinkedHashSet<RBC>();
        List<IAttrHolder> childRecords = this.childRetriever.apply(new Integer(jobMstId));
        if (childRecords != null) {
            for (IAttrHolder child : childRecords) {
                this.addRbcIfDefined(retSet, child);
                retSet.addAll(this.getAllDecsendantsRBCs(child.getAttrAsInt("JOBMST_ID")));
                if (!this.isInactiveSub(child) && (this.isCalendarInherited(child) || !child.getAttrAsInt("EVNTMST_ID").equals(UNDEFINED_CALENDAR) || !child.getAttrAsInt("JOBMST_TYPE").equals(1))) continue;
                retSet.add(new RBC(NEVER_RUN_TAG));
            }
        }
        return retSet;
    }

    private void addRbcIfDefined(Set<RBC> targetSet, IAttrHolder jobMstRecord) {
        Integer evntMstId = jobMstRecord.getAttrAsInt("EVNTMST_ID");
        if (this.isDentifiedEvent(evntMstId)) {
            this.validateEventExistInEventTable(jobMstRecord, evntMstId);
            List<RBC> rbc = new RbcFactory(this::getEvntGroupChildren, this::getEventYearListByID, this::getEventConditionsListByID, this::getEventMstByID).generateRbcs(this.evntMstTable.get(evntMstId.intValue()));
            List onlyIncludeRBCs = rbc.stream().filter(cal -> !cal.getName().startsWith("!")).collect(Collectors.toList());
            targetSet.addAll(onlyIncludeRBCs);
        }
    }

    private Set<RBC> inheritRbcFromAncestor(IAttrHolder jobMstRecord) {
        LinkedHashSet<RBC> toRet = new LinkedHashSet<RBC>();
        Integer parentId = jobMstRecord.getAttrAsInt("JOBMST_PRNTID");
        if (!parentId.equals(0)) {
            IAttrHolder parentRecord = this.jobMstTable.get(parentId.intValue());
            Integer evntMstId = parentRecord.getAttrAsInt("EVNTMST_ID");
            if (this.isDentifiedEvent(evntMstId)) {
                this.validateEventExistInEventTable(jobMstRecord, evntMstId);
                RbcFactory rbcFactory = new RbcFactory(this::getEvntGroupChildren, this::getEventYearListByID, this::getEventConditionsListByID, this::getEventMstByID);
                IAttrHolder event = this.evntMstTable.get(evntMstId.intValue());
                List<RBC> rbcs = new RbcFactory(this::getEvntGroupChildren, this::getEventYearListByID, this::getEventConditionsListByID, this::getEventMstByID).generateRbcs(this.evntMstTable.get(evntMstId.intValue()));
                toRet.addAll(rbcs);
            } else if (this.isCalendarInherited(parentRecord)) {
                toRet.addAll(this.inheritRbcFromAncestor(parentRecord));
            } else {
                toRet.add(new RBC(NEVER_RUN_TAG));
            }
        }
        return toRet;
    }

    private boolean isDentifiedEvent(Integer evntMstId) {
        return !UNDEFINED_CALENDAR.equals(evntMstId);
    }

    private void validateEventExistInEventTable(IAttrHolder jobMstRecord, int eventId) throws RuntimeException {
        IAttrHolder event = this.evntMstTable.get(eventId);
        if (event == null) {
            String jobId = jobMstRecord.getAttr("JOBMST_ID");
            throw new RuntimeException(String.format("\nInvalid data:\n\nThe job id (%1$s) has a reference to event id (%2$s).\nThe event id (%2$s) is missing from the EVNTMST table.\nTry extracting the data again or contact BMC support\n", jobId, eventId));
        }
    }

    private boolean isCalendarInherited(IAttrHolder jobMstRecord) {
        IAttrHolder jobDtlRecord = this.jobDtlTable.get(jobMstRecord.getAttrAsInt("JOBDTL_ID").intValue());
        return jobDtlRecord != null && jobDtlRecord.getAttr("JOBDTL_INHEVENT").equalsIgnoreCase("Y");
    }

    public List<IAttrHolder> getEvntGroupChildren(int evntMstId) {
        ArrayList<IAttrHolder> childListMst = new ArrayList<IAttrHolder>();
        List<IAttrHolder> evntChildsTableList = this.evntChildTable.getAllRecords().stream().filter(rec -> evntMstId == rec.getAttrAsInt("EVNTMST_ID")).toList();
        for (IAttrHolder child : evntChildsTableList) {
            Integer evntMstChildID = child.getAttrAsInt("EVNTCHLD_PRNTID");
            IAttrHolder evntAttr = this.evntMstTable.get(evntMstChildID.intValue());
            if (evntAttr == null) continue;
            AttrHolder evntChildMst = ((AttrHolder)evntAttr).clone();
            evntChildMst.appendAttr("EVNTCHLD_LOGIC", child.getAttr("EVNTCHLD_LOGIC"));
            evntChildMst.appendAttr("EVNTCHLD_OFFSET", child.getAttr("EVNTCHLD_OFFSET"));
            childListMst.add((IAttrHolder)evntChildMst);
        }
        return childListMst;
    }

    @FunctionalInterface
    public static interface GroupChildrenGetter {
        public List<IAttrHolder> getchildren(int var1);
    }

    @FunctionalInterface
    public static interface EventYearListGetter {
        public List<IAttrHolder> getYearList(int var1);
    }

    @FunctionalInterface
    public static interface EventConditionsGetter {
        public List<IAttrHolder> getConditions(int var1);
    }

    @FunctionalInterface
    public static interface EventGetter {
        public IAttrHolder getEvent(int var1);
    }
}

