/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tidal.FilterDataProvider;
import com.bmc.ctmconvert.tidal.JobmstFilter;
import com.bmc.ctmconvert.utils.Pair;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Jobmst
extends CsvFile {
    private HashMap<Integer, AttrHolderList> m_parents = null;
    private static Jobmst m_instance = null;
    private HashMap<Integer, IAttrHolder> ID2Job = new HashMap();

    public static Jobmst instance() {
        if (m_instance == null) {
            m_instance = new Jobmst();
            m_instance.load();
        }
        return m_instance;
    }

    public static Jobmst instance(InputStream mstInStream) {
        if (m_instance == null) {
            m_instance = new Jobmst();
            m_instance.loadInternal(mstInStream);
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public void load() {
        String csvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "JOBMST.csv";
        this.load(csvFile);
        this.filterMst();
    }

    public void loadInternal(InputStream mstInStream) {
        this.load(mstInStream);
        this.filterMst();
    }

    public void filterMst() {
        List<FilterDataProvider> providersList = this.getProviders();
        RulesDataSet.FilterData filterHandler = RuleManager.instance().getCurrentRules().getFilterHandler();
        if (!filterHandler.isEmptyFilter()) {
            JobmstFilter filter = new JobmstFilter(this.m_parents, filterHandler, providersList);
            this.m_parents = filter.getFilteredParentMap();
        }
    }

    private List<FilterDataProvider> getProviders() {
        ArrayList<FilterDataProvider> result = new ArrayList<FilterDataProvider>();
        FilterDataProvider jobmstNameProvider = this.getJobNameProvider();
        result.add(jobmstNameProvider);
        FilterDataProvider jobmstOwnerNameProvider = this.getJobOwnerNameProvider();
        result.add(jobmstOwnerNameProvider);
        return result;
    }

    private FilterDataProvider getJobOwnerNameProvider() {
        return x -> {
            String value = "";
            RecordsHolder ownersRecords = new RecordsHolder(Params.instance().getDatasourcePath() + Globs.DIRSEP + "OWNER.csv", "OWNER_ID");
            IAttrHolder jobmst = this.ID2Job.get(x);
            Integer ownerId = jobmst.getAttrAsInt("JOBMST_OWNER");
            if (ownerId != 0) {
                value = ownersRecords.get(ownerId.intValue()).getAttr("OWNER_NAME");
            }
            return new Pair((Object)"Job's owner name", (Object)value);
        };
    }

    private FilterDataProvider getJobNameProvider() {
        return x -> {
            String jobmstName = this.ID2Job.get(x).getAttr("JOBMST_NAME");
            return new Pair((Object)"Job/Group name", (Object)jobmstName);
        };
    }

    protected void handleRecord(IAttrHolder job, int record_number) {
        int parentId;
        if (!this.isToBeLoaded(job)) {
            return;
        }
        int jobmst_id = job.getAttrAsInt("JOBMST_ID");
        this.ID2Job.put(jobmst_id, job);
        String job_parent_str = job.getAttr("JOBMST_PRNTID");
        try {
            parentId = Integer.parseInt(job_parent_str);
        }
        catch (NumberFormatException ex) {
            parentId = 0;
        }
        AttrHolderList list = this.m_parents.get(parentId);
        if (list == null) {
            list = new AttrHolderList();
            this.m_parents.put(parentId, list);
        }
        list.add((Object)job);
    }

    private boolean isToBeLoaded(IAttrHolder job) {
        boolean ignoreInactiveJobs = RuleManager.instance().getCurrentRules().getBooleanRule("Additional Tidal rules", new String[]{"IGNORE_INACTIVE"});
        if (job.getAttr("JOBMST_ID") == null || job.getAttr("JOBMST_ID").isEmpty()) {
            return false;
        }
        if (job.getAttr("JOBMST_DIRTY") != null && job.getAttr("JOBMST_DIRTY").equalsIgnoreCase("X")) {
            return false;
        }
        return !ignoreInactiveJobs || job.getAttr("JOBMST_ACTIVE") == null || !job.getAttr("JOBMST_ACTIVE").equalsIgnoreCase("N");
    }

    private Jobmst() {
        this.m_parents = new HashMap();
    }

    public AttrHolderList getChilds(int parentId) {
        AttrHolderList toRet = new AttrHolderList();
        if (this.hasChilds(parentId)) {
            toRet = this.m_parents.get(parentId);
        }
        return toRet;
    }

    public boolean hasChilds(int parentId) {
        return this.m_parents.containsKey(parentId);
    }

    public boolean isLoaded(int jobmst_id) {
        return this.ID2Job.containsKey(jobmst_id);
    }

    public IAttrHolder getAttrbyJobID(int jobID) {
        return this.ID2Job.get(jobID);
    }
}

