/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.VarMstTable;
import java.util.HashMap;
import java.util.Map;

public class HandleEnvFileVariable {
    private static final String SPACE = " ";
    private String cmdLineParameters;
    private String envFileValue = "";
    private Map<String, Map<String, String>> variableId2ValuesMap = new HashMap<String, Map<String, String>>();
    private StringBuilder commandLine;
    private boolean isWindowsPlatform;

    public HandleEnvFileVariable(StringBuilder cmdContainer, String cmdLineParameters, IAttrHolder DtlJobRecord, VarMstTable varMstInstance, boolean isWindowsPlatform) {
        this.commandLine = cmdContainer;
        this.cmdLineParameters = cmdLineParameters;
        this.isWindowsPlatform = isWindowsPlatform;
        this.envFileValue = DtlJobRecord.getAttr("JOBDTL_ENVFILE");
        this.checkIfVariableOrHardCodedValue();
    }

    public StringBuilder getUpdatedCommandLine() {
        StringBuilder updatedCmdLine = new StringBuilder();
        if (this.envFileValue == null || this.envFileValue.isEmpty()) {
            return this.commandLine.append(SPACE).append(this.cmdLineParameters);
        }
        if (!this.isWindowsPlatform) {
            updatedCmdLine.append(". ");
        }
        updatedCmdLine.append(this.envFileValue);
        if (this.commandLine.length() > 0 && !this.commandLine.toString().equals(". ")) {
            updatedCmdLine.append(SPACE);
            if (!updatedCmdLine.toString().trim().isEmpty()) {
                updatedCmdLine.append("&& ");
            }
            updatedCmdLine.append(this.commandLine.toString());
        }
        updatedCmdLine.append(SPACE);
        if (!this.cmdLineParameters.trim().isEmpty()) {
            updatedCmdLine.append(this.cmdLineParameters);
        }
        return updatedCmdLine;
    }

    private void checkIfVariableOrHardCodedValue() {
        if (this.envFileValue != null && !this.envFileValue.isEmpty()) {
            String potenialVariableNumber;
            int indexOfDot = this.envFileValue.indexOf(46);
            int index = this.envFileValue.lastIndexOf(62);
            if (indexOfDot > 0 && index > 0 && indexOfDot + 1 < index && GlobalFunctions.isNumber((String)(potenialVariableNumber = this.envFileValue.substring(indexOfDot + 1, index)))) {
                return;
            }
            this.removeBrackets();
        }
    }

    private void removeBrackets() {
        this.envFileValue = this.envFileValue.replaceAll("<", "");
        this.envFileValue = this.envFileValue.replaceAll(">", "");
    }
}

