/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.tidal.TidalRecordsHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class TidalDefData {
    private String datasourcePath;
    private InputStream indipendentJobmstInputStream = null;
    private InputStream inputStream = null;
    private Map<String, InputStream> inputStreamMap;

    public TidalDefData(String datasourcePath) {
        this.datasourcePath = datasourcePath;
        this.inputStreamMap = new HashMap<String, InputStream>();
    }

    public InputStream getInputStream(String fileName) {
        if (!this.inputStreamMap.containsKey(fileName)) {
            Path csvPath = Paths.get(this.datasourcePath + fileName + ".csv", new String[0]);
            try {
                this.inputStream = Files.newInputStream(csvPath, new OpenOption[0]);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
                this.inputStream = new ByteArrayInputStream("".getBytes());
            }
            this.inputStreamMap.put(fileName, this.inputStream);
        } else {
            this.inputStream = this.inputStreamMap.get(fileName);
        }
        return this.inputStream;
    }

    public void setInputStream(String fileName, InputStream inputStream) {
        this.inputStreamMap.put(fileName, inputStream);
    }

    public InputStream getIndipendentJobmstInputStream() {
        if (this.indipendentJobmstInputStream == null) {
            Path mstCsvPath = Paths.get(this.datasourcePath + "JOBMST.csv", new String[0]);
            try {
                this.indipendentJobmstInputStream = Files.newInputStream(mstCsvPath, new OpenOption[0]);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
                this.indipendentJobmstInputStream = new ByteArrayInputStream("".getBytes());
            }
        }
        return this.indipendentJobmstInputStream;
    }

    public void setIndipendentJobmstInputStream(InputStream indipendentJobmstInputStream) {
        this.indipendentJobmstInputStream = indipendentJobmstInputStream;
    }

    public HashMap<String, RecordsHolder> getDataSource() {
        HashMap<String, RecordsHolder> m_dataSource = new HashMap<String, RecordsHolder>();
        m_dataSource.put("JOBDTL", new RecordsHolder(this.getInputStream("JOBDTL"), "JOBDTL_ID"));
        m_dataSource.put("NODMST", new RecordsHolder(this.getInputStream("NODMST"), "NODMST_ID"));
        m_dataSource.put("OWNER", new RecordsHolder(this.getInputStream("OWNER"), "OWNER_ID"));
        m_dataSource.put("USRMST", new RecordsHolder(this.getInputStream("USRMST"), "USRMST_ID"));
        m_dataSource.put("RESMST", new RecordsHolder(this.getInputStream("RESMST"), "RESMST_ID"));
        m_dataSource.put("VARMST", new RecordsHolder(this.getInputStream("VARMST"), "VARMST_ID"));
        m_dataSource.put("TRGMST", new RecordsHolder(this.getInputStream("TRGMST"), "TRGMST_ID"));
        m_dataSource.put("EVNTMST", new RecordsHolder(this.getInputStream("EVNTMST"), "EVNTMST_ID"));
        m_dataSource.put("EVNTYEAR", new RecordsHolder(this.getInputStream("EVNTYEAR"), "EVNTYEAR_ID"));
        m_dataSource.put("EVNTFSCL", new RecordsHolder(this.getInputStream("EVNTFSCL"), "EVNTFSCL_ID"));
        m_dataSource.put("EVNTCHLD", new RecordsHolder(this.getInputStream("EVNTCHLD"), "EVNTCHLD_ID"));
        m_dataSource.put("EVNTCOND", new RecordsHolder(this.getInputStream("EVNTCOND"), "EVNTCOND_ID"));
        m_dataSource.put("WORKUSR", new RecordsHolder(this.getInputStream("WORKUSR"), "OWNER_ID"));
        m_dataSource.put("WORKGRP", new RecordsHolder(this.getInputStream("WORKGRP"), "WORKGRP_ID"));
        m_dataSource.put("JOBCLS", new RecordsHolder(this.getInputStream("JOBCLS"), "JOBCLS_ID"));
        m_dataSource.put("JOBRES", new RecordsHolder(this.getInputStream("JOBRES"), "JOBMST_ID"));
        m_dataSource.put("JOBMST", new TidalRecordsHolder(this.getInputStream("JOBMST"), "JOBMST_ID"));
        m_dataSource.put("SERVICEMST", new RecordsHolder(this.getInputStream("SERVICEMST"), "SERVICEMST_ID"));
        m_dataSource.put("BIZUNIT", new RecordsHolder(this.getInputStream("BIZUNIT"), "BIZUNIT_ID"));
        return m_dataSource;
    }
}

