/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "length", "", "blobType", "byteType", "dateTimeType", "floatType", "integerAutoincType", "longAutoincType", "ubyteType", "uuidToDB", "", "value", "Ljava/util/UUID;", "uuidType", "exposed-core"})
public final class PostgreSQLDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final PostgreSQLDataTypeProvider INSTANCE = new PostgreSQLDataTypeProvider();

    private PostgreSQLDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String floatType() {
        return "REAL";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "SERIAL";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "BIGSERIAL";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "uuid";
    }

    @Override
    @NotNull
    public String binaryType() {
        return "bytea";
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        SQLLogKt.getExposedLogger().warn("The length of the binary column is not required.");
        return this.binaryType();
    }

    @Override
    @NotNull
    public String blobType() {
        return "bytea";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "SMALLINT";
    }
}

