/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Ljava/util/UUID;", "valueToUUID", "Companion", "exposed-core"})
public final class UUIDColumnType
extends ColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        boolean bl;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof UUID) {
            object2 = (UUID)value;
            return object2;
        }
        if (value instanceof byte[]) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])value);
            boolean bl2 = false;
            boolean bl3 = false;
            ByteBuffer b = byteBuffer;
            boolean bl4 = false;
            object2 = new UUID(b.getLong(), b.getLong());
            return object2;
        }
        if (value instanceof String) {
            object = (CharSequence)value;
            Regex regex = uuidRegexp;
            bl = false;
            if (regex.matches((CharSequence)object)) {
                object = UUID.fromString((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromString(value)");
                object2 = object;
                return object2;
            }
        }
        if (value instanceof String) {
            object = (String)value;
            Charset charset = Charsets.UTF_8;
            bl = false;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = ByteBuffer.wrap(byArray);
            boolean bl5 = false;
            bl = false;
            Object b = object;
            boolean bl6 = false;
            object2 = new UUID(((ByteBuffer)b).getLong(), ((ByteBuffer)b).getLong());
            return object2;
        }
        object = "Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
        boolean bl7 = false;
        throw (Throwable)new IllegalStateException(object.toString());
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidToDB(this.valueToUUID(value));
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "" + '\'' + this.valueToUUID(value) + '\'';
    }

    private final UUID valueToUUID(Object value) {
        UUID uUID;
        Object object = value;
        if (object instanceof UUID) {
            uUID = (UUID)value;
        } else if (object instanceof String) {
            UUID uUID2 = UUID.fromString((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(value)");
            uUID = uUID2;
        } else if (object instanceof byte[]) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer it = byteBuffer;
            boolean bl3 = false;
            uUID = new UUID(it.getLong(), it.getLong());
        } else {
            String string = Intrinsics.stringPlus((String)"Unexpected value of type UUID: ", (Object)value.getClass().getCanonicalName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return uUID;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType$Companion;", "", "()V", "uuidRegexp", "Lkotlin/text/Regex;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

