/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\r\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\tH\u00c2\u0003JI\u0010+\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0-H\u0016J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\t0-H\u0016J\t\u00106\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0010\u00a8\u00067"}, d2={"Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "target", "Lorg/jetbrains/exposed/sql/Column;", "from", "onUpdate", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "onDelete", "name", "", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ReferenceOption;Lorg/jetbrains/exposed/sql/ReferenceOption;Ljava/lang/String;)V", "customFkName", "getCustomFkName", "()Ljava/lang/String;", "deleteRule", "getDeleteRule", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "fkName", "getFkName", "foreignKeyPart", "getForeignKeyPart$exposed_core", "getFrom", "()Lorg/jetbrains/exposed/sql/Column;", "fromColumn", "getFromColumn", "fromTable", "getFromTable", "getTarget", "targetColumn", "getTargetColumn", "targetTable", "getTargetTable", "tx", "Lorg/jetbrains/exposed/sql/Transaction;", "getTx", "()Lorg/jetbrains/exposed/sql/Transaction;", "updateRule", "getUpdateRule", "component1", "component2", "component3", "component4", "component5", "copy", "createStatement", "", "dropStatement", "equals", "", "other", "", "hashCode", "", "modifyStatement", "toString", "exposed-core"})
public final class ForeignKeyConstraint
implements DdlAware {
    @NotNull
    private final Column<?> target;
    @NotNull
    private final Column<?> from;
    @Nullable
    private final ReferenceOption onUpdate;
    @Nullable
    private final ReferenceOption onDelete;
    @Nullable
    private final String name;

    public ForeignKeyConstraint(@NotNull Column<?> target, @NotNull Column<?> from, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.target = target;
        this.from = from;
        this.onUpdate = onUpdate;
        this.onDelete = onDelete;
        this.name = name;
    }

    @NotNull
    public final Column<?> getTarget() {
        return this.target;
    }

    @NotNull
    public final Column<?> getFrom() {
        return this.from;
    }

    private final Transaction getTx() {
        return TransactionManager.Companion.current();
    }

    @NotNull
    public final String getTargetTable() {
        return this.getTx().identity(this.target.getTable());
    }

    @NotNull
    public final String getTargetColumn() {
        return this.getTx().identity(this.target);
    }

    @NotNull
    public final String getFromTable() {
        return this.getTx().identity(this.from.getTable());
    }

    @NotNull
    public final String getFromColumn() {
        return this.getTx().identity(this.from);
    }

    @Nullable
    public final ReferenceOption getUpdateRule() {
        DatabaseDialect databaseDialect;
        ReferenceOption referenceOption = this.onUpdate;
        return referenceOption == null ? ((databaseDialect = DefaultKt.getCurrentDialectIfAvailable()) == null ? null : databaseDialect.getDefaultReferenceOption()) : referenceOption;
    }

    @Nullable
    public final ReferenceOption getDeleteRule() {
        DatabaseDialect databaseDialect;
        ReferenceOption referenceOption = this.onDelete;
        return referenceOption == null ? ((databaseDialect = DefaultKt.getCurrentDialectIfAvailable()) == null ? null : databaseDialect.getDefaultReferenceOption()) : referenceOption;
    }

    @Nullable
    public final String getCustomFkName() {
        return this.name;
    }

    @NotNull
    public final String getFkName() {
        String string;
        return DefaultKt.inProperCase(this.getTx().getDb().getIdentifierManager().cutIfNecessaryAndQuote((string = this.name) == null ? "fk_" + this.from.getTable().getTableNameWithoutScheme$exposed_core() + '_' + this.from.getName() + '_' + this.target.getName() : string));
    }

    @NotNull
    public final String getForeignKeyPart$exposed_core() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$_get_foreignKeyPart__u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        CharSequence charSequence = this.getFkName();
        boolean bl6 = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            $this$_get_foreignKeyPart__u24lambda_u2d0.append("CONSTRAINT " + this.getFkName() + ' ');
        }
        $this$_get_foreignKeyPart__u24lambda_u2d0.append("FOREIGN KEY (" + this.getFromColumn() + ") REFERENCES " + this.getTargetTable() + '(' + this.getTargetColumn() + ')');
        if (this.getDeleteRule() != ReferenceOption.NO_ACTION) {
            $this$_get_foreignKeyPart__u24lambda_u2d0.append(Intrinsics.stringPlus((String)" ON DELETE ", (Object)((Object)this.getDeleteRule())));
        }
        if (this.getUpdateRule() != ReferenceOption.NO_ACTION) {
            if (DefaultKt.getCurrentDialect() instanceof OracleDialect) {
                SQLLogKt.getExposedLogger().warn("Oracle doesn't support FOREIGN KEY with ON UPDATE clause. Please check your " + this.getFromTable() + " table.");
            } else {
                $this$_get_foreignKeyPart__u24lambda_u2d0.append(Intrinsics.stringPlus((String)" ON UPDATE ", (Object)((Object)this.getUpdateRule())));
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTable() + " ADD " + this.getForeignKeyPart$exposed_core()));
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        String constraintType = databaseDialect instanceof MysqlDialect ? "FOREIGN KEY" : "CONSTRAINT";
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTable() + " DROP " + constraintType + ' ' + this.getFkName()));
    }

    @NotNull
    public final Column<?> component1() {
        return this.target;
    }

    @NotNull
    public final Column<?> component2() {
        return this.from;
    }

    private final ReferenceOption component3() {
        return this.onUpdate;
    }

    private final ReferenceOption component4() {
        return this.onDelete;
    }

    private final String component5() {
        return this.name;
    }

    @NotNull
    public final ForeignKeyConstraint copy(@NotNull Column<?> target, @NotNull Column<?> from, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        return new ForeignKeyConstraint(target, from, onUpdate, onDelete, name);
    }

    public static /* synthetic */ ForeignKeyConstraint copy$default(ForeignKeyConstraint foreignKeyConstraint, Column column, Column column2, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            column = foreignKeyConstraint.target;
        }
        if ((n & 2) != 0) {
            column2 = foreignKeyConstraint.from;
        }
        if ((n & 4) != 0) {
            referenceOption = foreignKeyConstraint.onUpdate;
        }
        if ((n & 8) != 0) {
            referenceOption2 = foreignKeyConstraint.onDelete;
        }
        if ((n & 0x10) != 0) {
            string = foreignKeyConstraint.name;
        }
        return foreignKeyConstraint.copy(column, column2, referenceOption, referenceOption2, string);
    }

    @NotNull
    public String toString() {
        return "ForeignKeyConstraint(target=" + this.target + ", from=" + this.from + ", onUpdate=" + (Object)((Object)this.onUpdate) + ", onDelete=" + (Object)((Object)this.onDelete) + ", name=" + this.name + ')';
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = result * 31 + this.from.hashCode();
        result = result * 31 + (this.onUpdate == null ? 0 : this.onUpdate.hashCode());
        result = result * 31 + (this.onDelete == null ? 0 : this.onDelete.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForeignKeyConstraint)) {
            return false;
        }
        ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)other;
        if (!Intrinsics.areEqual(this.target, foreignKeyConstraint.target)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.from, foreignKeyConstraint.from)) {
            return false;
        }
        if (this.onUpdate != foreignKeyConstraint.onUpdate) {
            return false;
        }
        if (this.onDelete != foreignKeyConstraint.onDelete) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)foreignKeyConstraint.name);
    }
}

