/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/internal/InternalHexConverter;", "", "()V", "hexCode", "", "hexToInt", "", "ch", "", "parseHexBinary", "", "s", "printHexBinary", "data", "lowerCase", "", "toHexString", "n", "kotlinx-serialization-core"})
public final class InternalHexConverter {
    @NotNull
    public static final InternalHexConverter INSTANCE = new InternalHexConverter();
    @NotNull
    private static final String hexCode = "0123456789ABCDEF";

    private InternalHexConverter() {
    }

    @NotNull
    public final byte[] parseHexBinary(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int len = s.length();
        boolean bl = len % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "HexBinary string must be even length";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = this.hexToInt(s.charAt(i));
            int l = this.hexToInt(s.charAt(i + 1));
            boolean bl5 = h != -1 && l != -1;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl5) {
                boolean bl8 = false;
                String string = "Invalid hex chars: " + s.charAt(i) + s.charAt(i + 1);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bytes[i / 2] = (byte)((h << 4) + l);
        }
        return bytes;
    }

    private final int hexToInt(char ch) {
        int n;
        block1: {
            char c;
            block0: {
                c = ch;
                boolean bl = '0' <= c ? c <= '9' : false;
                if (!bl) break block0;
                n = ch - 48;
                break block1;
            }
            n = ('A' <= c ? c <= 'F' : false) ? ch - 65 + 10 : (('a' <= c ? c <= 'f' : false) ? ch - 97 + 10 : -1);
        }
        return n;
    }

    @NotNull
    public final String printHexBinary(@NotNull byte[] data, boolean lowerCase) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode.charAt(b >> 4 & 0xF));
            r.append(hexCode.charAt(b & 0xF));
        }
        if (lowerCase) {
            object2 = r.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"r.toString()");
            int n = 0;
            String string = ((String)object2).toLowerCase(Locale.ROOT);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        } else {
            object2 = r.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"r.toString()");
            object = object2;
        }
        return object;
    }

    public static /* synthetic */ String printHexBinary$default(InternalHexConverter internalHexConverter, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return internalHexConverter.printHexBinary(byArray, bl);
    }

    @NotNull
    public final String toHexString(int n) {
        byte[] arr = new byte[4];
        int n2 = 0;
        do {
            int i = n2++;
            arr[i] = (byte)(n >> 24 - i * 8);
        } while (n2 < 4);
        Object object = new char[]{'0'};
        object = StringsKt.trimStart((String)this.printHexBinary(arr, true), (char[])object);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl4 = false;
        Object object2 = (char[])(charSequence.length() > 0 ? object : null);
        return object2 == null ? "0" : (Object)object2;
    }
}

