/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.readers;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.dataimport.fileimporter.StorerFileReader;
import com.bmc.ctmconvert.jp1.exceptions.SyntaxErrorException;
import com.bmc.ctmconvert.jp1.readers.CommentsToFileWriter;
import com.bmc.ctmconvert.jp1.readers.JP1Scanner;
import com.bmc.ctmconvert.jp1.readers.JP1Unit;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class Jp1FileReader
implements StorerFileReader {
    private final UnitHandler unitHandler;
    private final CommentsToFileWriter commentHandler;

    public Jp1FileReader(UnitHandler unitHandler) {
        this(unitHandler, null);
    }

    public Jp1FileReader(UnitHandler unitHandler, CommentsToFileWriter commentHandler) {
        this.unitHandler = unitHandler;
        this.commentHandler = commentHandler;
    }

    public void readFile(File dataFile) {
        try {
            this.readFile(new FileInputStream(dataFile));
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new FailToReadFileException(e.getMessage());
        }
    }

    public void readFile(InputStream inputStream) {
        try (JP1Scanner scanner = new JP1Scanner(inputStream, SettingsTable.instance().getProperty(SettingsStringKeys.JP1_INPUT_FILE_ENCODING));){
            scanner.setCommentHandler(this.commentHandler);
            InternalFileReader filereader = new InternalFileReader(scanner, this.unitHandler);
            filereader.readFile();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new FailToReadFileException(e.getMessage());
        }
    }

    public static class UnitHandler {
        private final OnMemoryStorer storage;

        public UnitHandler(OnMemoryStorer storage) {
            this.storage = storage;
        }

        public int handleUnit(int parentId, JP1Unit unit) {
            return this.storage.store(parentId, unit.getAllAttributes());
        }
    }

    public static class FailToReadFileException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FailToReadFileException(String message) {
            super(message);
        }
    }

    public static class InternalFileReader {
        private final JP1Scanner scanner;
        private final UnitHandler unitHandler;

        public InternalFileReader(JP1Scanner scanner, UnitHandler storer) {
            this.scanner = scanner;
            this.unitHandler = storer;
        }

        public void readFile() {
            this.scanner.skipIgnoredLines();
            while (this.scanner.hasNextUnit()) {
                int containerId = this.readUnit(0);
                this.readChildren(containerId);
            }
        }

        private void readChildren(int containerId) {
            while (!this.scanner.hasNextEndOfUnit()) {
                this.readChildren(this.readUnit(containerId));
            }
            if (!this.scanner.hasNextEndOfUnit()) {
                throw new SyntaxErrorException(this.scanner.getCurrentLineNumber(), this.scanner.getLastLineRead());
            }
            this.scanner.skipCloseBrackets();
        }

        private int readUnit(int parentId) {
            if (this.scanner.hasNextUnit()) {
                return this.unitHandler.handleUnit(parentId, this.scanner.readNextUnit());
            }
            throw new SyntaxErrorException(this.scanner.getCurrentLineNumber(), this.scanner.getLastLineRead());
        }
    }
}

