/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.common.dataObject.query.DataObjectQuery;
import com.bmc.ctmconvert.common.dataObject.query.HasAttributeQuery;
import com.bmc.ctmconvert.common.dataObject.query.KeyValueQuery;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.rbc.NoneRbc;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.Queries.EmptyJobsnetsQuery;
import com.bmc.ctmconvert.jp1.Queries.JobNetsQuery;
import com.bmc.ctmconvert.jp1.Queries.JobsQuery;
import com.bmc.ctmconvert.jp1.actions.StartTimeStAction;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.jp1.convertors.JP1CalendarsConvertor;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.Jobnet;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.scheduling.JobScheduler;
import com.bmc.ctmconvert.utils.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;

public class Jp1Scheduler {
    private final JP1CalendarsConvertor calendarsConvertor = new JP1CalendarsConvertor();
    private final OnMemoryStorer dataObject;
    private final DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver;

    public Jp1Scheduler(OnMemoryStorer dataobject, DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver) {
        this.dataObject = dataobject;
        this.dataObjectEntityToCtmJobResolver = dataObjectEntityToCtmJobResolver;
    }

    private void createCalendars() {
        DataObjectQuery allGroupsQuery = db -> {
            KeyValueQuery groupsQuery = new KeyValueQuery("ty", "g");
            return groupsQuery.filter(db);
        };
        this.dataObject.stream().filterEntites(allGroupsQuery).forEachAttributes(this.calendarsConvertor::addCalendar);
        this.dataObject.getCalendars().forEach(this.calendarsConvertor::addRegularCalendar);
        this.calendarsConvertor.writeCalendars();
    }

    public void addSchedulingToJobs() {
        this.createCalendars();
        this.convertJobsScheduling();
        this.createDefaultScheduling();
        this.handleStartTime();
    }

    private void convertJobsScheduling() {
        JobScheduler jobScheduler = new JobScheduler(this.dataObject, this.dataObjectEntityToCtmJobResolver, this.calendarsConvertor::getCalendarByGroupId);
        this.dataObject.stream().filterEntites((DataObjectQuery)new EmptyJobsnetsQuery()).forEachEntityId((Consumer)jobScheduler);
        this.dataObject.stream().filterEntites((DataObjectQuery)new JobsQuery()).forEachEntityId((Consumer)jobScheduler);
        this.dataObject.getEntitiesAttributes().forEach(this::convertRbc);
    }

    private void createDefaultScheduling() {
        this.dataObject.stream().filterEntites((DataObjectQuery)new JobsQuery()).forEachEntityId(this::addDefaultSchedulingToEquivalentCtmEntity);
        this.dataObject.stream().filterEntites((DataObjectQuery)new JobNetsQuery()).forEachEntityId(this::addDefaultSchedulingToEquivalentCtmEntity);
    }

    private void addDefaultSchedulingToEquivalentCtmEntity(Integer id) {
        WorkspaceEntity job = this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId(id);
        if (job != null && job.getScheduling().isEmpty()) {
            job.addAttribute("TAG_RELATIONSHIP", "OR");
            job.addScheduling(NoneRbc.getProperties());
        }
    }

    private void convertRbc(Integer jobId, List<Pair<String, String>> attribs) {
        attribs.stream().filter(a -> "jc".equals(a.getKey())).map(Pair::getValue).findFirst().map(jcAttr -> jcAttr.contains("/") ? jcAttr.substring(jcAttr.lastIndexOf(47) + 1) : jcAttr).ifPresent(calendarName -> this.addRbcToCtmJob(this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId(jobId), jobId, (String)calendarName));
    }

    private void addRbcToCtmJob(WorkspaceEntity job, Integer jobId, String calendarName) {
        Properties rbc = new Properties();
        rbc.put("LEVEL", "Y");
        rbc.put("NAME", calendarName);
        job.addScheduling(rbc);
        job.getScheduling().stream().filter(p -> p.get("NAME").equals("Everyday") || p.get("NAME").toString().startsWith("Everyday#")).findFirst().ifPresent(everydayCalendar -> {
            job.getScheduling().remove(everydayCalendar);
            Object from = everydayCalendar.get("ACTIVE_FROM");
            if (from != null) {
                job.addAttribute("ACTIVE_FROM", from.toString());
            }
        });
        this.dataObject.getChildrenIds(jobId).forEach(childId -> {
            WorkspaceEntity childJob = this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId((Integer)childId);
            this.addRbcToCtmJob(childJob, (Integer)childId, calendarName);
        });
    }

    Jobnet getJobnet(Integer jobnetId) {
        List attributesPairs = this.dataObject.getAttributes(jobnetId);
        Attributes jobnetAttributes = new Attributes(attributesPairs);
        MessageHandler handler = (messageID, params) -> {
            WorkspaceEntity ctmEntity = this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId(jobnetId);
            ctmEntity.addMessage(messageID, params);
        };
        return new Jobnet(jobnetAttributes, handler);
    }

    private void handleStartTime() {
        this.dataObject.stream().filterEntites((DataObjectQuery)new HasAttributeQuery("st")).forEachEntityId(jobnetId -> {
            String baseTime = this.dataObject.getAttributeValueFromParent(jobnetId.intValue(), "stt").orElse("");
            List fromTime = this.dataObject.getAttribute("st", jobnetId);
            WorkspaceEntity folder = this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId((Integer)jobnetId);
            new StartTimeStAction().act(folder, fromTime, baseTime);
        });
    }

    @FunctionalInterface
    public static interface DataObjectEntityToCtmJobResolver {
        public WorkspaceEntity getWorkspaceEntityFromDataObjectEntityId(Integer var1);
    }

    @FunctionalInterface
    public static interface GroupIdToCalendarResolver {
        public Optional<JP1Calendar> getGroupCalendar(Integer var1);
    }

    @FunctionalInterface
    public static interface RulesGetter {
        public List<JobnetRule> getRules(Integer var1);
    }
}

