/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.jp1Entities;

import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.SingleRuleAttributes;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RulesAttributesList {
    private final List<SingleRuleAttributes> rulesAttributesList;
    private static final List<String> handledAttributes = Arrays.asList("sd", "cy", "st", "jc");
    private static final List<String> ignoredAttributes = Arrays.asList("de", "cftd", "wt", "wc", "stt", "sdd");
    public static final List<String> messagedAttributes = Arrays.asList("sh", "shd", "ln", "ed", "ejn");

    public RulesAttributesList(Attributes attributes) {
        Set<Pair<String, List<String>>> rulesAttributesSet = this.getRulesAttributesSet(attributes);
        this.rulesAttributesList = new RulesListGenerator(rulesAttributesSet).generateRulesListByNumber();
    }

    private Set<Pair<String, List<String>>> getRulesAttributesSet(Attributes attributes) {
        ArrayList<String> fullAttributesList = new ArrayList<String>();
        fullAttributesList.addAll(handledAttributes);
        fullAttributesList.addAll(ignoredAttributes);
        fullAttributesList.addAll(messagedAttributes);
        HashSet<Pair<String, List<String>>> attributesSet = new HashSet<Pair<String, List<String>>>();
        for (String attributeName : fullAttributesList) {
            List attributeValues = attributes.getValuesof(attributeName);
            attributesSet.add((Pair<String, List<String>>)new Pair((Object)attributeName, (Object)attributeValues));
        }
        return attributesSet;
    }

    public List<SingleRuleAttributes> getList() {
        return new ArrayList<SingleRuleAttributes>(this.rulesAttributesList);
    }

    private static class RulesListGenerator {
        private static final Pattern RULENUMBER_PATTERN = Pattern.compile("(?<RULENUMBER>\\d+)\\s*,\\s*.*");
        private final List<SingleRuleAttributes> result = new ArrayList<SingleRuleAttributes>();
        private final Map<Integer, Map<String, String>> ruleAttributesMap = new HashMap<Integer, Map<String, String>>();
        private final Set<Pair<String, List<String>>> attributesSet;

        public RulesListGenerator(Set<Pair<String, List<String>>> attributesSet) {
            this.attributesSet = attributesSet;
        }

        private List<SingleRuleAttributes> generateRulesListByNumber() {
            this.groupAttributesByRuleNumber(this.attributesSet);
            this.generateSingleRulesList();
            return this.result;
        }

        public void generateSingleRulesList() {
            for (Integer ruleNumber : this.ruleAttributesMap.keySet()) {
                SingleRuleAttributes singleRuleAttributes = new SingleRuleAttributes(ruleNumber, this.ruleAttributesMap.get(ruleNumber));
                this.result.add(singleRuleAttributes);
            }
        }

        public void groupAttributesByRuleNumber(Set<Pair<String, List<String>>> attributesSet) {
            for (Pair<String, List<String>> attributesPair : attributesSet) {
                ((List)attributesPair.getValue()).forEach(currentAttributeValue -> this.ruleAttributesMap.computeIfAbsent(this.getRuleNumber((String)currentAttributeValue), HashMap::new).put((String)attributesPair.getKey(), currentAttributeValue));
            }
        }

        private Integer getRuleNumber(String value) {
            Matcher m = RULENUMBER_PATTERN.matcher(value);
            if (!m.matches()) {
                return 1;
            }
            return Integer.parseInt(m.group("RULENUMBER"));
        }
    }
}

