/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.assesmentReport;

import com.bmc.ctmconvert.Jp1DataObjectReciver;
import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.assessmentreport.AssesmentReportEntity;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Jp1AssessmentReport
extends AbstractAssessmentReport {
    private static List<AssesmentReportEntity> assesmentReportEntitsList = null;
    private OnMemoryStorer dataObject;

    public Jp1AssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
        this.m_descriptionTypeLookNodesHandler = (v, n, i) -> 2;
    }

    private DefaultMutableTreeNode handleAssesmentTree() {
        this.dataObject = Jp1DataObjectReciver.get();
        return this.buildAssesmentReportTreeHirarchy(this.dataObject);
    }

    private List<AssesmentReportEntity> fillTreeItems(DataObject dataObject) {
        assesmentReportEntitsList = new ArrayList<AssesmentReportEntity>();
        Map hirarchyStruct = dataObject.getHirarchy();
        Set entititesIds = hirarchyStruct.keySet();
        for (Integer entityId : entititesIds) {
            List attributesForentityId = dataObject.getAttributes(entityId);
            String unitName = "";
            String unitType = "";
            for (Pair pairItem : attributesForentityId) {
                if (((String)pairItem.getKey()).equals("UNIT_NAME")) {
                    unitName = (String)pairItem.getValue();
                }
                if (!((String)pairItem.getKey()).equals("ty")) continue;
                unitType = (String)pairItem.getValue();
            }
            AssesmentReportEntity entity = new AssesmentReportEntity(String.valueOf(entityId), String.valueOf((Integer)hirarchyStruct.get(entityId)), unitName, unitType, attributesForentityId);
            assesmentReportEntitsList.add(entity);
        }
        return assesmentReportEntitsList;
    }

    private DefaultMutableTreeNode buildAssesmentReportTreeHirarchy(OnMemoryStorer dataObject) {
        List<AssesmentReportEntity> itemsList = this.fillTreeItems((DataObject)dataObject);
        Map calendars = dataObject.getCalendars();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new AssesmentReportEntity("0", "0", "JP1", "", Collections.emptyList()));
        DefaultMutableTreeNode unitsNode = new DefaultMutableTreeNode(new AssesmentReportEntity("0", "1", "Units(" + itemsList.size() + ")", "", Collections.emptyList()));
        DefaultMutableTreeNode calendarsNode = new DefaultMutableTreeNode(new AssesmentReportEntity("0", "1", "Calendars(" + calendars.size() + ")", "", Collections.emptyList()));
        rootNode.add(unitsNode);
        rootNode.add(calendarsNode);
        for (AssesmentReportEntity node : itemsList) {
            if ("0".equals(node.getHirarchy())) {
                DefaultMutableTreeNode parent = new DefaultMutableTreeNode(node);
                unitsNode.add(parent);
                continue;
            }
            DefaultMutableTreeNode returnNodeFromSearch = this.getNodeByDFS(unitsNode, node.getHirarchy());
            if (returnNodeFromSearch == null) continue;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(node);
            returnNodeFromSearch.add(child);
        }
        int calNum = 0;
        for (Map.Entry cal : calendars.entrySet()) {
            AssesmentReportEntity entity = new AssesmentReportEntity("calendar_" + calNum++, "1", (String)cal.getKey(), "Calendar", Collections.singletonList(new Pair((Object)"content", (Object)((String)cal.getValue()))));
            calendarsNode.add(new DefaultMutableTreeNode(entity));
        }
        return rootNode;
    }

    private String buildAttributesText(AssesmentReportEntity retNode) {
        List attributes = retNode.getAttributes();
        StringBuilder sb = new StringBuilder();
        if (retNode.getName().startsWith("Units(")) {
            return this.getSummary();
        }
        for (Pair item : attributes) {
            sb.append((String)item.getKey());
            sb.append("=");
            sb.append((String)item.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getSummary() {
        Integer numberOfGroups = this.getNumberOfGroups();
        Integer numberOfJobnets = this.getNumberOfJobnet();
        return "Summary:\n\nNumber Of Groups:" + numberOfGroups + "\n\nNumber Of Jobnets:" + numberOfJobnets + "\n\nNumber Of Jobs:" + (this.getNumberOfUnits() - this.getNumberOfOtherUnits() - numberOfJobnets - numberOfGroups) + "\n\n";
    }

    private Integer getNumberOfUnits() {
        Counter count = new Counter();
        this.dataObject.whenHasAttribute("ty", count::incrementOne);
        return count.getNumber();
    }

    private Integer getNumberOfGroups() {
        Counter count = new Counter();
        this.dataObject.WhenAttributeEqual("ty", "g", count::incrementOne);
        this.dataObject.WhenAttributeEqual("ty", "mg", count::incrementOne);
        return count.getNumber();
    }

    private Integer getNumberOfJobnet() {
        Counter count = new Counter();
        this.dataObject.WhenAttributeEqual("ty", "n", count::incrementOne);
        this.dataObject.WhenAttributeEqual("ty", "rn", count::incrementOne);
        this.dataObject.WhenAttributeEqual("ty", "rm", count::incrementOne);
        this.dataObject.WhenAttributeEqual("ty", "mn", count::incrementOne);
        this.dataObject.WhenAttributeEqual("ty", "rr", count::incrementOne);
        return count.getNumber();
    }

    private Integer getNumberOfOtherUnits() {
        Counter counter = new Counter();
        this.dataObject.WhenAttributeEqual("ty", "rc", counter::incrementOne);
        this.dataObject.WhenAttributeEqual("ty", "nc", counter::incrementOne);
        return counter.getNumber();
    }

    private DefaultMutableTreeNode getNodeByDFS(DefaultMutableTreeNode root, String nodeHirarchyValue) {
        DefaultMutableTreeNode retVal = null;
        Enumeration<TreeNode> nodesEnums = root.depthFirstEnumeration();
        while (nodesEnums.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodesEnums.nextElement();
            String nodeId = ((AssesmentReportEntity)currentNode.getUserObject()).getId();
            if (!nodeId.equals(nodeHirarchyValue)) continue;
            retVal = currentNode;
            break;
        }
        return retVal;
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        return this.handleAssesmentTree();
    }

    protected String getJobInfo(String messageID) {
        return null;
    }

    protected String getJobInfo(DefaultMutableTreeNode node) {
        String retVal = "";
        if (node != null && !"JP1".equals(node.toString())) {
            AssesmentReportEntity nodeObject = (AssesmentReportEntity)node.getUserObject();
            String nodeId = nodeObject.getId();
            if (node.toString().startsWith("Units(")) {
                retVal = this.getSummary();
            } else if (nodeId != null && !nodeId.isEmpty()) {
                if (nodeId.startsWith("calendar_")) {
                    retVal = (String)((Pair)nodeObject.getAttributes().getFirst()).getValue();
                } else {
                    int index = assesmentReportEntitsList.indexOf(new AssesmentReportEntity(nodeId));
                    if (index > -1) {
                        retVal = this.buildAttributesText(assesmentReportEntitsList.get(index));
                    }
                }
            }
        }
        return retVal;
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        return this.getNodesNames();
    }

    private ArrayList<String> getNodesNames() {
        ArrayList<String> nodesIdsList = new ArrayList<String>();
        for (AssesmentReportEntity entity : assesmentReportEntitsList) {
            nodesIdsList.add(entity.getName());
        }
        return nodesIdsList;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        return this.buildDescriptionNodes();
    }

    private HashMap<String, String> buildDescriptionNodes() {
        HashMap<String, String> descriptionNodes = new HashMap<String, String>();
        for (AssesmentReportEntity entity : assesmentReportEntitsList) {
            descriptionNodes.put(entity.getId(), this.buildAttributesText(entity));
        }
        return descriptionNodes;
    }

    protected void updateDescriptionAreaOfParentNode(String nodeName, DefaultMutableTreeNode node) {
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }

        public String toString() {
            return String.valueOf(this.count);
        }

        public Integer getNumber() {
            return this.count;
        }

        public void incrementOne() {
            ++this.count;
        }
    }
}

