/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.actions;

import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.actions.Action;
import com.bmc.ctmconvert.jp1.operations.NoOp;
import com.bmc.ctmconvert.jp1.operations.ValueOperation;
import java.util.Optional;

public class DirectAttributeSetterAction
implements Action {
    private String sourceAttribute;
    private String targetAttribute;
    private DataObject dataObject;
    private ValueOperation operation;

    public DirectAttributeSetterAction(String sourceAttribute, String targetAttribute, DataObject dataObject) {
        this(sourceAttribute, targetAttribute, new NoOp(), dataObject);
    }

    public DirectAttributeSetterAction(String sourceAttribute, String targetAttribute, ValueOperation operation, DataObject dataObject) {
        if (sourceAttribute == null || sourceAttribute.isEmpty()) {
            throw new IllegalArgumentException("Source attribute must be non-empty");
        }
        if (targetAttribute == null || targetAttribute.isEmpty()) {
            throw new IllegalArgumentException("Target attribute must be non-empty");
        }
        this.sourceAttribute = sourceAttribute;
        this.targetAttribute = targetAttribute;
        this.dataObject = dataObject;
        this.operation = operation;
    }

    @Override
    public void act(int id, WorkspaceEntity job) throws IllegalArgumentException {
        Optional attribute = this.dataObject.findFirstAttribute(this.sourceAttribute, Integer.valueOf(id));
        if (attribute.isPresent()) {
            String attributeValue = this.operation.apply((String)attribute.get());
            job.addAttribute(this.targetAttribute, attributeValue);
        } else if (this.operation.getDefaultValue().isPresent()) {
            job.addAttribute(this.targetAttribute, this.operation.getDefaultValue().get());
        }
    }

    public void setOperation(ValueOperation operation) {
        this.operation = operation;
    }
}

