/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.report;

import com.bmc.ctmconvert.gui.report.FullReportPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;

class topPanelTableCellRenderer
extends DefaultTableCellRenderer {
    private JTextArea cell;
    private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();
    private static final long serialVersionUID = 1L;
    private boolean markLastLine = false;
    private Font dftColumnFont = null;

    public topPanelTableCellRenderer(boolean withTotalLine) {
        this.markLastLine = withTotalLine;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        CompoundBorder border;
        this.setCell((JLabel)super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column));
        if (this.dftColumnFont == null) {
            this.dftColumnFont = this.cell.getFont();
        }
        this.cell.setFont(this.dftColumnFont);
        if (row == table.getRowCount() - 1) {
            if (this.markLastLine) {
                Font lastLineFont = new Font(this.dftColumnFont.getFamily().toString() + " Bold", 1, this.dftColumnFont.getSize() + 2);
                this.cell.setFont(lastLineFont);
            }
            border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
            this.cell.setBorder(border);
        }
        if (this.markLastLine && row % 2 == 1) {
            border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
            this.cell.setBorder(border);
        }
        if (table.getColumnName(column) == FullReportPanel.COL_HEADING_COUNT || table.getColumnName(column) == FullReportPanel.COL_HEADING_AFFECT_JOBS) {
            this.setHorizontalAlignment(4);
        }
        if (obj != null) {
            this.cell.setText(obj.toString());
        } else {
            this.cell.setText("");
        }
        this.adjustRowHeight(table, row, column);
        return this.cell;
    }

    private void setCell(JLabel base) {
        this.cell = new JTextArea();
        this.cell.setLineWrap(true);
        this.cell.setWrapStyleWord(true);
        this.cell.setOpaque(true);
    }

    private void adjustRowHeight(JTable table, int row, int column) {
        int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
        this.cell.setSize(new Dimension(cWidth, 1000));
        int prefH = this.cell.getPreferredSize().height;
        while (this.rowColHeight.size() <= row) {
            this.rowColHeight.add(new ArrayList(column));
        }
        List<Integer> colHeights = this.rowColHeight.get(row);
        while (colHeights.size() <= column) {
            colHeights.add(0);
        }
        colHeights.set(column, prefH);
        int maxH = prefH;
        for (Integer colHeight : colHeights) {
            if (colHeight <= maxH) continue;
            maxH = colHeight;
        }
        if (table.getRowHeight(row) < maxH) {
            table.setRowHeight(row, maxH);
        }
    }
}

