/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxVariables;
import com.bmc.ctmconvert.appworx.NotificationsTable;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConditionsResolver {
    public static final String DOSHOUT = "DOSHOUT";
    public static final String DOAUTOEDIT2 = "DOAUTOEDIT2";
    public static final String SUBVAR = "SUBVAR";
    public static final String SUBVAR_RUN = "SUBVAR_RUN";
    public static final String DOSTMT = "DOSTMT";
    public static final String NEW_JOB_NEEDED = "NEW_JOB_NEEDED";
    public static final String NOT_CONVERTED_CONDITION = "NC_COND";
    public static final String NOT_CONVERTED_CONDITION_1_SUBVAR = "NC_COND_1_SUBVAR";
    public static final String NOT_CONVERTED_ACTION = "NC_ACT";
    public static final String NOT_CONVERTED_ACTION_RJ = "NOT_CONVERTED_ACTION_RJ";
    public static final String NO_NEED_TO_CONVERT = "NO_NEED_TO_CONVERT";
    public static final String INVALID_OR_MISSING_DATA = "INVALID_OR_MISSING_DATA";
    public static final String OLD_APPWORX_VALUE = "OLD_APPWORX_VALUE";
    public static final String CONDITIONS_GENERATED = "CONDITIONS_GENERATED";
    public static final String UNSUPPORTED_SUBVAR_USAGE = "UNSUPPORTED_SUBVAR_USAGE";
    public static final String NOT_CONVERTED_TIMING = "NC_TIMING";
    private static final Map.Entry<String, List<Properties>> ENTRY_NOT_CONVERTED_ACTION = new AbstractMap.SimpleEntry<String, Object>("NC_ACT", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_NOT_CONVERTED_ACTION_RJ = new AbstractMap.SimpleEntry<String, Object>("NOT_CONVERTED_ACTION_RJ", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_NOT_CONVERTED_SUBVAR_USAGE = new AbstractMap.SimpleEntry<String, Object>("UNSUPPORTED_SUBVAR_USAGE", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_NOT_CONVERTED_CONDITION = new AbstractMap.SimpleEntry<String, Object>("NC_COND", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_NOT_CONVERTED_CONDITION_1_SUBVAR = new AbstractMap.SimpleEntry<String, Object>("NC_COND_1_SUBVAR", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_IVALID_OR_MISSING_DATA = new AbstractMap.SimpleEntry<String, Object>("INVALID_OR_MISSING_DATA", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_OLD_APPWORX_VALUE = new AbstractMap.SimpleEntry<String, Object>("OLD_APPWORX_VALUE", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_CONDITIONS_GENERATED = new AbstractMap.SimpleEntry<String, Object>("CONDITIONS_GENERATED", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_NO_NEED_TO_CONVERT = new AbstractMap.SimpleEntry<String, Object>("NO_NEED_TO_CONVERT", null);
    private static final Map.Entry<String, List<Properties>> ENTRY_NOT_CONVERTED_TIMING = new AbstractMap.SimpleEntry<String, Object>("NC_TIMING", null);

    private static final boolean isAlwaysTrue(String val1, String qualifier, String val2) {
        try {
            int iVal1 = Integer.parseInt(val1);
            int iVal2 = Integer.parseInt(val2);
            if (qualifier.equals("!=") || qualifier.equals("<>")) {
                return iVal1 != iVal2;
            }
            if (qualifier.equals("<")) {
                return iVal1 < iVal2;
            }
            if (qualifier.equals("<=")) {
                return iVal1 <= iVal2;
            }
            if (qualifier.equals("=")) {
                return iVal1 == iVal2;
            }
            if (qualifier.equals(">")) {
                return iVal1 > iVal2;
            }
            if (qualifier.equals(">=")) {
                return iVal1 >= iVal2;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static final Map.Entry<String, List<Properties>> convertConditionRow(AttrHolderList inList, String sCommandSep, boolean bIsJob) {
        Map.Entry<String, List<Properties>> result = null;
        for (IAttrHolder currentRow : inList) {
            String sAction = currentRow.getAttr("so_action");
            if (null == sAction || sAction.isEmpty()) {
                return ENTRY_IVALID_OR_MISSING_DATA;
            }
            String sCond1 = currentRow.getAttr("so_condition_1");
            if (null == sCond1 || sCond1.isEmpty()) {
                return ENTRY_IVALID_OR_MISSING_DATA;
            }
            if (sCond1.contains("{") || sCond1.contains("#")) {
                return ENTRY_NOT_CONVERTED_CONDITION_1_SUBVAR;
            }
            if ((sCond1 = sCond1.toUpperCase()).equals("MODULE REQUESTED") || sCond1.equals("MODULE RUNNING")) {
                return ENTRY_OLD_APPWORX_VALUE;
            }
            sAction = sAction.toUpperCase();
            for (String sUnsupported : APPWORX_ACTIONS.ACTIONS_UNSUPPORTED) {
                if (!sAction.equals(sUnsupported)) continue;
                return ENTRY_NOT_CONVERTED_ACTION;
            }
            if (sAction.equals("REQUEST JOB")) {
                return ENTRY_NOT_CONVERTED_ACTION_RJ;
            }
            String sTiming = currentRow.getAttr("so_cond_timing");
            if (null == sTiming) {
                return ENTRY_IVALID_OR_MISSING_DATA;
            }
            if (!((sTiming = sTiming.toUpperCase().trim()).equals("A") || sTiming.equals("B") || sTiming.equals("D") || sTiming.equals("R"))) {
                return ENTRY_IVALID_OR_MISSING_DATA;
            }
            String sQualifier = currentRow.getAttr("so_qualifier");
            String sCond2 = currentRow.getAttr("so_condition_2");
            if (null == sQualifier || sQualifier.isEmpty() || null == sCond2 || sCond2.isEmpty()) {
                return ENTRY_IVALID_OR_MISSING_DATA;
            }
            boolean bIsAlwaysTrue = ConditionsResolver.isAlwaysTrue(sCond1, sQualifier = sQualifier.toUpperCase(), sCond2 = sCond2.toUpperCase()) || sCond1.equals("ALWAYS TRUE");
            String sActionArgs = currentRow.getAttr("so_act_arg");
            if (bIsAlwaysTrue) {
                if (sAction.equals("SET SUBVAR") || sAction.equals("DELETE SUBVAR")) {
                    Map.Entry<String, String> convertedSubVar = ConditionsResolver.convertSubVar(sActionArgs, false);
                    if (null == convertedSubVar) {
                        return ENTRY_NOT_CONVERTED_SUBVAR_USAGE;
                    }
                    Properties varVal = new Properties();
                    varVal.put(convertedSubVar.getKey(), convertedSubVar.getValue());
                    ArrayList<Properties> innerList = new ArrayList<Properties>(1);
                    innerList.add(varVal);
                    return new AbstractMap.SimpleEntry<String, List<Properties>>(SUBVAR, innerList);
                }
                if (bIsJob) {
                    if (sAction.equals("RESTART ON ABORT")) {
                        if (!sActionArgs.toUpperCase().equals("Y")) {
                            return ENTRY_NO_NEED_TO_CONVERT;
                        }
                        Properties doSTMT = ConditionsResolver.restartOnAbort("RETURN CODE", "NE", "0");
                        if (null != doSTMT) {
                            ArrayList<Properties> innerList = new ArrayList<Properties>(1);
                            innerList.add(doSTMT);
                            return new AbstractMap.SimpleEntry<String, List<Properties>>(DOSTMT, innerList);
                        }
                        return ENTRY_IVALID_OR_MISSING_DATA;
                    }
                    return ConditionsResolver.convertAlwaysTrueActionForJob(sAction, sActionArgs, sTiming, sCommandSep);
                }
                Map.Entry<String, List<Properties>> convertTest = ConditionsResolver.convertAlwaysTrueActionForJob(sAction, sActionArgs, "B", sCommandSep);
                if (convertTest.getKey().equals(SUBVAR)) {
                    return new AbstractMap.SimpleEntry<String, List<Properties>>(NEW_JOB_NEEDED, convertTest.getValue());
                }
                return convertTest;
            }
            for (String sUnsupported : APPWORX_CONDITIONS.CONDITIONS_UNSUPPORTED) {
                if (!sCond1.equals(sUnsupported)) continue;
                return ENTRY_NOT_CONVERTED_CONDITION;
            }
            if (sAction.equals("RESTART ON ABORT")) {
                sTiming = "A";
            }
            if (sTiming.equals("A")) {
                if (!sCond1.equals("RETURN CODE") && !sCond1.equals("STATUS")) continue;
                result = ConditionsResolver.convertAfterActionForJob(sCond1, sQualifier, sCond2, sAction, sActionArgs);
                continue;
            }
            if (sTiming.equals("B")) {
                if (!ConditionsResolver.IsSupportedConditionActionPair(sCond1, sAction)) {
                    return ENTRY_NOT_CONVERTED_ACTION;
                }
                return ENTRY_CONDITIONS_GENERATED;
            }
            if (sTiming.equals("D")) {
                return ENTRY_NOT_CONVERTED_TIMING;
            }
            if (!sTiming.equals("R")) continue;
            return ENTRY_NOT_CONVERTED_TIMING;
        }
        return result;
    }

    private static final Map.Entry<String, List<Properties>> convertAlwaysTrueActionForJob(String sACT, String sActionArgs, String sTiming, String sCommandSep) {
        if (!sTiming.equals("A") && !sTiming.equals("B")) {
            return ENTRY_NOT_CONVERTED_ACTION;
        }
        ArrayList<Properties> messages = null;
        ArrayList<HashMap<String, String>> actions = null;
        String cmdAutoEditName = sTiming.equals("A") ? "%%POSTCMD" : "%%PRECMD";
        Object cmdAutoEditValue = null;
        boolean bRunHostCommand = false;
        if (sACT.equals("RUN HOST COMMAND")) {
            if (sActionArgs.contains("{")) {
                AppWorxVariables appWorxVariables = new AppWorxVariables(sActionArgs, AppWorxVariables.ReplaceType.ONLY_REPLACEMENT);
                cmdAutoEditValue = appWorxVariables.getAnnotatedText();
                messages = appWorxVariables.getMessages();
                actions = appWorxVariables.getActions();
            } else {
                cmdAutoEditValue = sActionArgs;
            }
            bRunHostCommand = true;
        } else if (sACT.equals("DELAY TASK")) {
            int iDelaySeconds = 10;
            if (null != sActionArgs) {
                String[] times = sActionArgs.split(":");
                if (null == times || times.length != 3) {
                    return ENTRY_NOT_CONVERTED_ACTION;
                }
                try {
                    iDelaySeconds = Integer.parseInt(times[0]) * 3600 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
                }
                catch (NumberFormatException e) {
                    iDelaySeconds = 10;
                }
            }
            cmdAutoEditValue = "_sleep " + iDelaySeconds;
        } else {
            if (sACT.equals("REQUEST JOB")) {
                return ENTRY_NOT_CONVERTED_ACTION_RJ;
            }
            if (sACT.equals("HOLD TASK")) {
                cmdAutoEditValue = "ctmpsm -updateajf %%ORDERID hold";
            } else if (sACT.equals("SET HOLD STATUS")) {
                Object sShout = "ctmshout -dest EM -message ";
                sShout = sActionArgs == null ? (String)sShout + "HOLD STATUS" : (String)sShout + sActionArgs;
                sShout = (String)sShout + " -orderid %%ORDERID";
                cmdAutoEditValue = "ctmpsm -updateajf %%ORDERID hold " + sCommandSep + (String)sShout;
            } else if (sACT.equals("SET FINISHED STATUS")) {
                Object sShout = "ctmshout -dest EM -message ";
                sShout = sActionArgs == null ? (String)sShout + "FINISHED STATUS" : (String)sShout + sActionArgs;
                sShout = (String)sShout + " -orderid %%ORDERID";
                cmdAutoEditValue = "ctmpsm -updateajf %%ORDERID forceok " + sCommandSep + (String)sShout;
            }
        }
        if (null != cmdAutoEditValue) {
            ArrayList<Properties> innerList = new ArrayList<Properties>();
            Properties varVal = new Properties();
            varVal.put(cmdAutoEditName, cmdAutoEditValue);
            if (messages != null && !messages.isEmpty()) {
                Properties messagesProperty = new Properties();
                messagesProperty.put("CONVERSION_MESSAGES_ARRAY", messages);
                innerList.add(messagesProperty);
            }
            if (actions != null && !actions.isEmpty()) {
                Properties actionsProperty = new Properties();
                actionsProperty.put("CONVERSION_ACTIONS_ARRAY", actions);
                innerList.add(actionsProperty);
            }
            innerList.add(varVal);
            return new AbstractMap.SimpleEntry<String, List<Properties>>(bRunHostCommand ? SUBVAR_RUN : SUBVAR, innerList);
        }
        return ENTRY_NOT_CONVERTED_ACTION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Map.Entry<String, List<Properties>> convertAfterActionForJob(String sCond1, String sQualifier, String sCond2, String sAction, String sActionArgs) {
        Properties firstStatement = new Properties();
        Properties secondStatement = null;
        ArrayList<Properties> innerList = new ArrayList<Properties>(2);
        String sCode = ConditionsResolver.getCOMPSTAT(sCond1, sQualifier, sCond2);
        if (null == sCode) {
            return ENTRY_IVALID_OR_MISSING_DATA;
        }
        firstStatement = new Properties();
        String sDoAction = null;
        if (sAction.equals("SET FINISHED STATUS")) {
            secondStatement = ConditionsResolver.createDoStatement(sCode, "*", DOSHOUT, sActionArgs == null ? sAction : sActionArgs);
            sDoAction = "OK";
        } else if (sAction.equals("ABORT TASK")) {
            sDoAction = "NOTOK";
        } else if (sAction.equals("SET ABORT STATUS")) {
            secondStatement = ConditionsResolver.createDoStatement(sCode, "*", DOSHOUT, sActionArgs == null ? sAction : sActionArgs);
            sDoAction = "NOTOK";
        } else if (sAction.equals("SET SUBVAR") || sAction.equals("DELETE SUBVAR")) {
            Map.Entry<String, String> sEntry = ConditionsResolver.convertSubVar(sActionArgs, true);
            if (null == sEntry) {
                return ENTRY_NOT_CONVERTED_ACTION;
            }
            sDoAction = DOAUTOEDIT2;
            firstStatement.put("NAME", sEntry.getKey());
            firstStatement.put("VALUE", sEntry.getValue());
        } else if (sAction.equals("RESTART ON ABORT")) {
            if (null != sActionArgs) {
                if (!sActionArgs.toUpperCase().equals("Y")) return ENTRY_NO_NEED_TO_CONVERT;
                firstStatement = ConditionsResolver.restartOnAbort(sCond1, sQualifier, sCond2);
                if (null == firstStatement) {
                    return ENTRY_IVALID_OR_MISSING_DATA;
                }
                sDoAction = "RERUN";
            }
        } else if (sAction.equals("SEND NOTIFICATION")) {
            ArrayList<HashMap<String, String>> actions;
            String name = sActionArgs.substring(0, sActionArgs.indexOf(" "));
            Properties notificationProperties = NotificationsTable.instance().getNitificationProperties(name);
            if (notificationProperties == null) {
                return ENTRY_IVALID_OR_MISSING_DATA;
            }
            sDoAction = "DOMAIL";
            firstStatement.putAll((Map<?, ?>)notificationProperties);
            ArrayList<Properties> messages = NotificationsTable.instance().getNitificationMessages(name);
            if (messages != null && !messages.isEmpty()) {
                Properties messagesProperty = new Properties();
                messagesProperty.put("CONVERSION_MESSAGES_ARRAY", messages);
                innerList.add(messagesProperty);
            }
            if ((actions = NotificationsTable.instance().getNitificationActions(name)) != null && !actions.isEmpty()) {
                Properties actionsProperty = new Properties();
                actionsProperty.put("CONVERSION_ACTIONS_ARRAY", actions);
                innerList.add(actionsProperty);
            }
        }
        if (null == sDoAction) return ENTRY_NOT_CONVERTED_ACTION;
        firstStatement.put("STMT", "*");
        firstStatement.put("CODE", sCode);
        firstStatement.put("ACTION", sDoAction);
        innerList.add(firstStatement);
        if (null == secondStatement) return new AbstractMap.SimpleEntry<String, List<Properties>>(DOSTMT, innerList);
        innerList.add(secondStatement);
        return new AbstractMap.SimpleEntry<String, List<Properties>>(DOSTMT, innerList);
    }

    private static final Map.Entry<String, String> convertSubVar(String sActionArgs, boolean bIsOnSTMT) {
        if (null == sActionArgs) {
            return null;
        }
        String sName = null;
        Object sValue = null;
        if (sActionArgs.contains("=")) {
            String[] sVR = sActionArgs.split("=");
            if (null == sVR || sVR.length != 2) {
                return null;
            }
            sName = sVR[0].substring(1);
            sValue = sVR[1];
        } else {
            sName = sActionArgs.substring(1);
        }
        if (sName.contains("#") || sName.contains("{")) {
            return null;
        }
        if (null != sValue) {
            if (((String)sValue).charAt(0) == '{') {
                if (((String)sValue).charAt(1) != '#') {
                    return null;
                }
                sValue = "%%" + ((String)sValue).substring(2, ((String)sValue).length() - 1);
            } else if (((String)sValue).charAt(0) == '#') {
                return null;
            }
        } else {
            sValue = "";
        }
        String varPrefix = "%%";
        if (!bIsOnSTMT) {
            varPrefix = "%%\\";
        }
        return new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)(varPrefix + sName)), (String)sValue);
    }

    private static final Properties restartOnAbort(String sCond1, String sQualifier, String sCond2) {
        String sCOMP = ConditionsResolver.getCOMPSTAT(sCond1, sQualifier, sCond2);
        if (null == sCOMP) {
            return null;
        }
        return ConditionsResolver.createDoStatement(sCOMP, "*", "RERUN", null);
    }

    private static final Properties createDoStatement(String sCode, String sSTMT, String sAction, String sMessage) {
        Properties result = null;
        if (sAction.equals("RERUN")) {
            result = new Properties();
            result.put("STMT", sSTMT);
            result.put("CODE", sCode);
            result.put("ACTION", sAction);
        } else if (sAction.equals(DOSHOUT)) {
            result = new Properties();
            result.put("STMT", sSTMT);
            result.put("CODE", sCode);
            result.put("ACTION", sAction);
            result.put("DEST", "EM");
            result.put("MESSAGE", sMessage);
            result.put("URGENCY", "R");
        }
        return result;
    }

    private static final String getCOMPSTAT(String sCond1, String sQualifier, String sCond2) {
        if (sCond1.equals("RETURN CODE")) {
            try {
                int iVal = Integer.parseInt(sCond2);
                String sNewQualifier = sQualifier;
                if (sQualifier.equals("GE")) {
                    sNewQualifier = "GT";
                    --iVal;
                } else if (sQualifier.equals("LE")) {
                    sNewQualifier = "LT";
                    ++iVal;
                } else if (!(sQualifier.equals("EQ") || sQualifier.equals("LT") || sQualifier.equals("GT") || sQualifier.equals("NE"))) {
                    return null;
                }
                return String.format("COMPSTAT %s %d", sNewQualifier, iVal);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (sCond1.equals("STATUS")) {
            String sNewQualifier = "EQ";
            if (!sCond2.toUpperCase().equals("FINISHED")) {
                sNewQualifier = "NE";
            }
            return String.format("COMPSTAT %s 0", sNewQualifier);
        }
        return null;
    }

    public static final boolean IsSupportedConditionActionPair(String sCondition, String sAction) {
        return null != sCondition && null != sAction && (sCondition.equalsIgnoreCase("CHECK HISTORY") ? sAction.equalsIgnoreCase("WAIT UNTIL MET") : (sCondition.equalsIgnoreCase("JOB REQUESTED") ? sAction.equalsIgnoreCase("WAIT UNTIL MET") || sAction.equalsIgnoreCase("DELAY TASK") : sCondition.equalsIgnoreCase("JOB RUNNING") && (sAction.equalsIgnoreCase("WAIT UNTIL MET") || sAction.equalsIgnoreCase("DELAY TASK"))));
    }

    public static final class APPWORX_CONDITIONS {
        public static final String CONDITION_USER_DEFINED = "USER DEFINED";
        public static final String CONDITION_ALWAYS_TRUE = "ALWAYS TRUE";
        public static final String CONDITION_CHECK_CONNECTION = "CHECK CONNECTION";
        public static final String CONDITION_CHECK_FILE = "CHECK FILE";
        public static final String CONDITION_CHECK_FILE_FTP = "CHECK FILE FTP";
        public static final String CONDITION_CHECK_HISTORY = "CHECK HISTORY";
        public static final String CONDITION_CHECK_PROCESS = "CHECK PROCESS";
        public static final String CONDITION_CURRENT_QUEUE = "CURRENT QUEUE";
        public static final String CONDITION_CURRENT_TIME = "CURRENT TIME";
        public static final String CONDITION_RETURN_CODE = "RETURN CODE";
        public static final String CONDITION_RUN_TIME = "RUN TIME";
        public static final String CONDITION_STATUS = "STATUS";
        public static final String CONDITION_TIME_SINCE_REQUEST = "TIME SINCE REQUEST";
        public static final String CONDITION_MODULE_REQUESTED = "MODULE REQUESTED";
        public static final String CONDITION_MODULE_RUNNING = "MODULE RUNNING";
        public static final String CONDITION_JOB_REQUESTED = "JOB REQUESTED";
        public static final String CONDITION_JOB_RUNNING = "JOB RUNNING";
        public static final String[] CONDITIONS_UNSUPPORTED = new String[]{"CHECK FILE", "CHECK FILE FTP", "CHECK CONNECTION", "CHECK PROCESS", "CURRENT QUEUE", "CURRENT TIME", "TIME SINCE REQUEST", "RUN TIME", "USER DEFINED", "ALWAYS TRUE"};
    }

    public static final class APPWORX_ACTIONS {
        public static final String ACTION_ABORT_TASK = "ABORT TASK";
        public static final String ACTION_CANCEL_PROCESS_FLOW = "CANCEL PROCESS FLOW";
        public static final String ACTION_CANCEL_SUB_PROCESS_FLOW = "CANCEL SUB PROCESS FLOW";
        public static final String ACTION_CHANGE_Q = "CHANGE Q";
        public static final String ACTION_DELAY_TASK = "DELAY TASK";
        public static final String ACTION_DELETE_SUBVAR = "DELETE SUBVAR";
        public static final String ACTION_EXTRACT_VALUE = "EXTRACT VALUE";
        public static final String ACTION_GOTO_CONDITION = "GOTO CONDITION";
        public static final String ACTION_HOLD_TASK = "HOLD TASK";
        public static final String ACTION_KILL_TASK = "KILL TASK";
        public static final String ACTION_REQUEST_JOB = "REQUEST JOB";
        public static final String ACTION_RESCHEDULE_TASK = "RESCHEDULE TASK";
        public static final String ACTION_RESTART_ON_ABORT = "RESTART ON ABORT";
        public static final String ACTION_RUN_HOST_COMMAND = "RUN HOST COMMAND";
        public static final String ACTION_RUN_TASK = "RUN TASK";
        public static final String ACTION_SEND_JMS_MESSAGE = "SEND JMS MESSAGE";
        public static final String ACTION_SEND_NOTIFICATION = "SEND NOTIFICATION";
        public static final String ACTION_SET_ABORT_STATUS = "SET ABORT STATUS";
        public static final String ACTION_SET_FINISHED_STATUS = "SET FINISHED STATUS";
        public static final String ACTION_SET_HOLD_STATUS = "SET HOLD STATUS";
        public static final String ACTION_SET_SKIP_STATUS = "SET SKIP STATUS";
        public static final String ACTION_SET_SUBVAR = "SET SUBVAR";
        public static final String ACTION_SKIP_TASK = "SKIP TASK";
        public static final String ACTION_STAY_IN_QUEUE_ON_ABORT = "STAY IN QUEUE ON ABORT";
        public static final String ACTION_WAIT_UNTIL_MET = "WAIT UNTIL MET";
        static final String[] ACTIONS_UNSUPPORTED = new String[]{"CANCEL PROCESS FLOW", "CANCEL SUB PROCESS FLOW", "CHANGE Q", "EXTRACT VALUE", "GOTO CONDITION", "KILL TASK", "RESCHEDULE TASK", "RUN TASK", "SEND JMS MESSAGE", "SET SKIP STATUS", "SKIP TASK", "STAY IN QUEUE ON ABORT"};
    }
}

