/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxJob;
import com.bmc.ctmconvert.appworx.AppWorxTaskTypeFieldsMapping;
import com.bmc.ctmconvert.appworx.BaseJobHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.LinkedHashMap;
import java.util.Properties;

public class CommandTaskHandler
implements BaseJobHandler {
    private String jobName;
    private AppWorxTaskTypeFieldsMapping appWorxTaskTypeFieldsMapper;
    private Properties properties;
    private LinkedHashMap<String, String> variables;
    private IAttrHolder library;
    private String program;
    private String cmdLine;
    private String nodePlatform;

    public CommandTaskHandler(AppWorxJob job, AppWorxTaskTypeFieldsMapping appWorxTaskTypeFieldsMapper, IAttrHolder library, String program) {
        this.library = library;
        this.program = program;
        this.nodePlatform = job.getNodePlatform();
        this.jobName = job.getJobName();
        this.appWorxTaskTypeFieldsMapper = appWorxTaskTypeFieldsMapper;
        this.properties = job.getProperties();
        this.variables = job.getAutoedits();
        this.resolveCmdLine();
        this.setCommandLineAttributes();
    }

    private void resolveCmdLine() {
        String filePath = this.appWorxTaskTypeFieldsMapper.getFilePath();
        String fileName = this.appWorxTaskTypeFieldsMapper.getFileName();
        String libraryPathType = this.nodePlatformResolver(this.nodePlatform);
        String libraryPath = this.library != null ? (libraryPathType.equals("") ? "" : this.library.getAttr(libraryPathType)) : "";
        StringBuilder cmdLineBuilder = new StringBuilder();
        cmdLineBuilder.append(filePath);
        cmdLineBuilder.append("/");
        cmdLineBuilder.append(fileName);
        cmdLineBuilder.append(" ");
        cmdLineBuilder.append(libraryPath);
        if (!libraryPath.isEmpty()) {
            cmdLineBuilder.append("/");
        }
        cmdLineBuilder.append(this.program);
        cmdLineBuilder.append(" ");
        this.variables.forEach((key, value) -> cmdLineBuilder.append("\"" + key + "\"").append(" "));
        this.cmdLine = cmdLineBuilder.toString();
    }

    private String nodePlatformResolver(String nodePlatform) {
        String retVal = "";
        if (nodePlatform != null && nodePlatform.equals("Unix")) {
            retVal = "so_library_path_unix";
        } else if (nodePlatform != null && nodePlatform.equals("Windows")) {
            retVal = "so_library_path_nt";
        }
        return retVal;
    }

    private void setCommandLineAttributes() {
        this.properties.setProperty("TASKTYPE", "Command");
        this.properties.setProperty("CMDLINE", this.cmdLine);
        this.properties.setProperty("MEMNAME", this.jobName);
    }

    @Override
    public Properties getJobProperties() {
        return new Properties(this.properties);
    }
}

