/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxEntity;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.Properties;

public class AppWorxTaskTypeFieldsMapping {
    private Properties properties;
    private String filePath = "";
    private String fileName = "";

    public AppWorxTaskTypeFieldsMapping(Properties properties) {
        this.properties = properties;
    }

    public Properties getScriptMapping() {
        this.properties.setProperty("TASKTYPE", "Job");
        this.properties.setProperty("MEMLIB", this.filePath);
        this.properties.setProperty("MEMNAME", this.fileName);
        return this.properties;
    }

    public void setFilePath(String nodePlatform, AppWorxEntity entityData) {
        String retVal = "";
        retVal = this.resolveValue(nodePlatform, entityData, "so_command_path_unix", "so_command_path_nt");
        this.filePath = retVal == null ? "" : retVal;
    }

    public void setFileName(String nodePlatform, AppWorxEntity entityData) {
        String retVal = "";
        retVal = this.resolveValue(nodePlatform, entityData, "so_host_command_unix", "so_host_command_nt");
        this.fileName = retVal == null ? "" : retVal;
    }

    private String resolveValue(String nodePlatform, AppWorxEntity entityData, String unixValue, String ntValue) {
        String retVal = "";
        IAttrHolder commandPathRecord = entityData.getCommandRecord(EntityTableManager.get(EntityTableManager.EntityType.so_command_paths));
        if (commandPathRecord != null) {
            String appworxPlatormDependentPath = "";
            if (nodePlatform.equals("Unix")) {
                appworxPlatormDependentPath = unixValue;
            } else if (nodePlatform.equals("Windows")) {
                appworxPlatormDependentPath = ntValue;
            }
            retVal = commandPathRecord.getAttr(appworxPlatormDependentPath);
        }
        return retVal;
    }

    public boolean isFilePathEmpty() {
        return this.filePath.isEmpty();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }
}

