/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxEntity;
import com.bmc.ctmconvert.appworx.CsvFileTable;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.rules.Rule;
import com.bmc.ctmconvert.rules.RuleManager;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class AppWorxHierarchyTree {
    private static AppWorxHierarchyTree instance;
    private static String datasource;
    private CsvFileTable chainTable;
    private CsvFileTable jobTable;
    private DefaultMutableTreeNode root;
    private HashMap<String, Integer> nodesList = new HashMap();

    public static AppWorxHierarchyTree instance() {
        String datasourceName = Params.instance().getDatasourceName();
        if (instance == null || !datasourceName.equals(datasource)) {
            datasource = datasourceName;
            instance = new AppWorxHierarchyTree();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private AppWorxHierarchyTree() {
        this.jobTable = EntityTableManager.get(EntityTableManager.EntityType.so_job_table);
        this.chainTable = EntityTableManager.get(EntityTableManager.EntityType.so_chain_detail);
        Rule convertJobWithParentRule = RuleManager.instance().getCurrentRules().getRule("AppWorx rules", new String[]{"CONVERT_ENTITIES_WITHOUT_PROCESSFLOW"});
        this.root = new AppWorxEntity(Params.instance().getDatasourceName());
        for (IAttrHolder entry : this.jobTable.getAttrHoldersList("so_command_type", "CHAIN")) {
            AttrHolderList parentsList = this.chainTable.getAttrHoldersList("so_module_1", entry.getAttr("so_module"));
            if (parentsList.size() != 0) continue;
            AppWorxEntity entityData = new AppWorxEntity(null, entry);
            this.addNodeCount(entry.getAttr("so_node"));
            this.root.add(this.getChildTree(entityData));
        }
        if (convertJobWithParentRule.getData().equals(true)) {
            AppWorxEntity jobsWithOutParent = this.getJobsWithoutProcessFlow();
            this.root.add(jobsWithOutParent);
        }
    }

    private void addNodeCount(String node) {
        if (node != null && !node.isEmpty()) {
            Integer nodeCnt = this.nodesList.get(node);
            if (nodeCnt == null) {
                nodeCnt = new Integer(0);
            }
            Integer n = nodeCnt;
            nodeCnt = nodeCnt + 1;
            this.nodesList.put(node, nodeCnt);
        }
    }

    private DefaultMutableTreeNode getChildTree(AppWorxEntity entityData) {
        AttrHolderList chainList = this.chainTable.getAttrHoldersList("so_module", entityData.getEntityName());
        if (!chainList.isEmpty()) {
            for (IAttrHolder child : chainList) {
                AttrHolderList childJobDetails = this.jobTable.getAttrHoldersList("so_module", child.getAttr("so_module_1"));
                if (childJobDetails.size() > 1) {
                    ExceptionHandler.writeToExceptionFile((String)("More then one jobTable entry for: " + child.getAttr("so_module_1")));
                    continue;
                }
                if (childJobDetails.isEmpty()) {
                    entityData.add(new AppWorxEntity(child, null));
                    continue;
                }
                this.addNodeCount(((IAttrHolder)childJobDetails.get(0)).getAttr("so_node"));
                entityData.add(this.getChildTree(new AppWorxEntity(child, (IAttrHolder)childJobDetails.get(0))));
            }
        }
        return entityData;
    }

    public DefaultMutableTreeNode getHierarchyTree() {
        return this.root;
    }

    public HashMap<String, Integer> getNodesList() {
        return this.nodesList;
    }

    public AppWorxEntity getJobsWithoutProcessFlow() {
        AppWorxEntity parentEntity = this.getEmptyEntity();
        CsvFileTable noProccessFlowJobs = EntityTableManager.get(EntityTableManager.EntityType.EntitesWithoutProcessFlows);
        for (IAttrHolder entry : noProccessFlowJobs.getAttrHoldersList()) {
            AttrHolderList childrenList = this.jobTable.getAttrHoldersList("so_module", entry.getAttr("so_module"));
            if (childrenList.size() == 0) continue;
            AppWorxEntity entityData = new AppWorxEntity(null, (IAttrHolder)childrenList.get(0));
            this.addNodeCount(((IAttrHolder)childrenList.get(0)).getAttr("so_node"));
            parentEntity.add(this.getChildTree(entityData));
        }
        return parentEntity;
    }

    private AppWorxEntity getEmptyEntity() {
        this.jobTable = EntityTableManager.get(EntityTableManager.EntityType.so_job_table);
        HashMap<String, Integer> headerToIndexMap = this.jobTable.getheaderToIndexMap();
        Object[] values = new String[headerToIndexMap.size()];
        Arrays.fill(values, "");
        AttrHolder attr = new AttrHolder((String[])values, headerToIndexMap);
        attr.setAttr("so_module", "EntitesWithoutProcessFlows");
        AppWorxEntity parentEntity = new AppWorxEntity(null, (IAttrHolder)attr);
        return parentEntity;
    }

    static {
        datasource = "";
    }
}

