/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.reader;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.data.FolderData;
import com.bmc.ctmconvert.flowupdater.data.HeaderData;
import com.bmc.ctmconvert.flowupdater.data.JobData;
import java.util.List;
import java.util.Map;

public class EntitiesHandler {
    DataObject dataObject = null;

    public EntitiesHandler(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public DataEntity storeFolder(XmlElement folderXml, DataEntity parentEntity) {
        DataEntity currentParentEntity = this.addFolderAttr(folderXml, parentEntity);
        List jobs = folderXml.getAllDirectchildsElement();
        for (XmlElement job : jobs) {
            if (job.getTagName().equals("SMART_FOLDER") || job.getTagName().equals("SUB_FOLDER") || job.getTagName().equals("SMART_TABLE") || job.getTagName().equals("SUB_TABLE")) {
                this.storeFolder(job, currentParentEntity);
                continue;
            }
            if (!job.getTagName().equals("JOB")) continue;
            this.addJobAttr(job, currentParentEntity);
        }
        return currentParentEntity;
    }

    public void storeHeader(String headerName, Map<String, String> headerAttributes) {
        HeaderData header = new HeaderData(headerName, headerAttributes);
        this.dataObject.store((Data)header);
    }

    private DataEntity addFolderAttr(XmlElement folderXml, DataEntity parentEntity) {
        String folderName = folderXml.getAttribute("FOLDER_NAME");
        if (folderName == null || folderName.isEmpty()) {
            folderName = folderXml.getAttribute("JOBNAME");
        }
        if (folderName == null || folderName.isEmpty()) {
            folderName = folderXml.getAttribute("TABLE_NAME");
        }
        FolderData folder = new FolderData(folderName, folderXml);
        DataEntity currentParentEntity = this.dataObject.store((Data)folder, parentEntity);
        return currentParentEntity;
    }

    private DataEntity addJobAttr(XmlElement jobXml, DataEntity parentEntity) {
        JobData job = new JobData(jobXml.getAttribute("JOBNAME"), jobXml);
        DataEntity de = this.dataObject.store((Data)job, parentEntity);
        return de;
    }
}

