/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.FolderXmlEntity;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubFolderCreator {
    private IWorkspace workspace;
    private Map<BaseXmlEntity, FolderXmlEntity> originalJobToSubFoldersMap;

    public SubFolderCreator(IWorkspace workspace) {
        this.workspace = workspace;
        this.originalJobToSubFoldersMap = new HashMap<BaseXmlEntity, FolderXmlEntity>();
    }

    public FolderXmlEntity generateSubFolder(IWorkspaceEntity jobWsEntity) {
        String name = jobWsEntity.getName();
        WorkspaceId subFolderToInjectWsID = new WorkspaceId();
        FolderXmlEntity workSpaceFolder = new FolderXmlEntity(subFolderToInjectWsID, name, "SUB_FOLDER");
        Folder wsParent = (Folder)jobWsEntity.getParent().get();
        workSpaceFolder.addAttribute("JOBNAME", name);
        Element rbc = this.getRbcElement();
        workSpaceFolder.addElement(new XmlElement(rbc));
        this.workspace.addFolder((Folder)workSpaceFolder);
        this.workspace.insertChildToFolder((IWorkspaceEntity)workSpaceFolder, wsParent);
        this.originalJobToSubFoldersMap.put((BaseXmlEntity)jobWsEntity, workSpaceFolder);
        this.workspace.removeJob(jobWsEntity);
        return workSpaceFolder;
    }

    private Element getRbcElement() {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("RULE_BASED_CALENDARS");
        root.setAttribute("NAME", "*");
        return root;
    }

    public Map<BaseXmlEntity, FolderXmlEntity> getOriginalJobToSubFoldersMap() {
        HashMap<BaseXmlEntity, FolderXmlEntity> ret = new HashMap<BaseXmlEntity, FolderXmlEntity>(this.originalJobToSubFoldersMap);
        return ret;
    }
}

