/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.flowupdater.inject.XmlAction;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowUpdaterOnCopier
implements XmlAction {
    private ElementCreator elementCreator = new ElementCreator(this);

    @Override
    public void act(BaseXmlEntity originalJob, BaseXmlEntity injectedSubFolder) {
        List jobOnElements = originalJob.getSubElements("ON");
        for (XmlElement onElement : jobOnElements) {
            String onCode = onElement.getAttribute("CODE");
            if (this.isValidOnForSubFolder(onCode)) {
                Element modifiedOnElement = this.elementCreator.createElement("ON");
                this.copyAttributes(onElement, modifiedOnElement);
                List doElements = onElement.getAllDirectchildsElement();
                List<Element> doToAdd = this.generateValidDo(doElements);
                this.issueMessgeForUnSupportedDo(doElements, injectedSubFolder);
                if (doToAdd.isEmpty()) {
                    String onTag = onElement.getAttribute("CODE");
                    injectedSubFolder.addMessage(new NewMessage("WRN19003", new String[]{onTag, injectedSubFolder.getName()}));
                    continue;
                }
                this.addOnToSubFolder(modifiedOnElement, doToAdd, injectedSubFolder);
                continue;
            }
            String onTagCode = onElement.getAttribute("CODE");
            injectedSubFolder.addMessage(new NewMessage("WRN19004", new String[]{injectedSubFolder.getName(), onTagCode}));
        }
    }

    private void addOnToSubFolder(Element modifiedOnElement, List<Element> doToAdd, BaseXmlEntity injectedSubFolder) {
        for (Element newDoElement : doToAdd) {
            modifiedOnElement.appendChild(newDoElement);
        }
        injectedSubFolder.addElement(new XmlElement(modifiedOnElement));
    }

    private void issueMessgeForUnSupportedDo(List<XmlElement> doElements, BaseXmlEntity injectedSubFolder) {
        ValidDoPredicate validDoPredicate = new ValidDoPredicate();
        List nonValidDoes = doElements.stream().filter(element -> !validDoPredicate.test(element)).collect(Collectors.toList());
        for (XmlElement doElement : nonValidDoes) {
            String doTagName = doElement.getTagName();
            String action = doElement.getAttribute("ACTION");
            Object doName = doTagName;
            if (!action.isEmpty()) {
                doName = (String)doName + " with ACTION:" + action;
            }
            injectedSubFolder.addMessage(new NewMessage("WRN19002", new String[]{injectedSubFolder.getName(), doName}));
        }
    }

    private void copyAttributes(XmlElement onElement, Element modifiedOnElement) {
        Set attrSet = onElement.getAttributes().entrySet();
        for (Map.Entry attr : attrSet) {
            String attrValue = (String)attr.getValue();
            String attrName = (String)attr.getKey();
            modifiedOnElement.setAttribute(attrName, attrValue);
        }
    }

    private boolean isValidOnForSubFolder(String onCode) {
        return onCode.equals("OK") || onCode.equals("NOTOK") || onCode.startsWith("FAILCOUNT=");
    }

    private List<Element> generateValidDo(List<XmlElement> doElements) {
        ArrayList<Element> retDo = new ArrayList<Element>();
        ValidDoPredicate validDoPredicate = new ValidDoPredicate();
        List validDoes = doElements.stream().filter(validDoPredicate).collect(Collectors.toList());
        for (XmlElement doElement : validDoes) {
            String doTagName = doElement.getTagName();
            Element newDoElement = this.elementCreator.createElement(doTagName);
            this.copyAttributes(doElement, newDoElement);
            retDo.add(newDoElement);
        }
        return retDo;
    }

    private boolean isValidDoAction(XmlElement doElement) {
        boolean isRerunAction = doElement.getAttribute("ACTION").equals("RERUN");
        boolean isSpsysAction = doElement.getAttribute("ACTION").equals("SPCYC");
        boolean isDoAction = doElement.getTagName().equals("DOACTION");
        return isDoAction && !isRerunAction && !isSpsysAction;
    }

    public class ElementCreator {
        private Document doc;

        public ElementCreator(FlowUpdaterOnCopier this$0) {
            DocumentBuilder builder;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                builder = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            this.doc = builder.newDocument();
        }

        public Element createElement(String tagName) {
            return this.doc.createElement(tagName);
        }
    }

    public class ValidDoPredicate
    implements Predicate<XmlElement> {
        @Override
        public boolean test(XmlElement doElement) {
            boolean ret = doElement.getTagName().equals("DOCOND") || doElement.getTagName().equals("DOSHOUT") || doElement.getTagName().equals("DOVARIABLE") || FlowUpdaterOnCopier.this.isValidDoAction(doElement) || doElement.getTagName().equals("DOFORCEJOB") || doElement.getTagName().equals("DOMAIL") || doElement.getTagName().equals("DOREMEDY");
            return ret;
        }
    }
}

