/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.FolderXmlEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowUpdaterFolderToSmart {
    private FolderXmlEntity injectedSubFolder;

    public FlowUpdaterFolderToSmart(FolderXmlEntity injectedSubFolder) {
        this.injectedSubFolder = injectedSubFolder;
    }

    public boolean isContainingFolderSmart() {
        boolean ret = false;
        SchedEntity.TYPE containingFolderType = ((Folder)this.injectedSubFolder.getParent().get()).getType();
        if (containingFolderType == SchedEntity.TYPE.SMART_TABLE || containingFolderType == SchedEntity.TYPE.SUB_TABLE) {
            ret = true;
        }
        return ret;
    }

    public void makeSmart() {
        FolderXmlEntity containingFolder = (FolderXmlEntity)this.injectedSubFolder.getParent().get();
        containingFolder.setTag("SMART_FOLDER");
        containingFolder.addAttribute("TYPE", "2");
        containingFolder.addAttribute("JOBNAME", containingFolder.getName());
        containingFolder.addAttribute("PARENT_FOLDER", containingFolder.getName());
        containingFolder.addAttribute("JOBISN", "0");
        containingFolder.addAttribute("CREATED_BY", "FlowUpdater");
        containingFolder.addAttribute("TASKTYPE", "SMART Table");
        containingFolder.addAttribute("CYCLIC", "0");
        containingFolder.addAttribute("INTERVAL", "00001M");
        containingFolder.addAttribute("CONFIRM", "0");
        containingFolder.addAttribute("MAXWAIT", "0");
        containingFolder.addAttribute("MAXRERUN", "0");
        containingFolder.addAttribute("MAXDAYS", "0");
        containingFolder.addAttribute("MAXRUNS", "0");
        containingFolder.addAttribute("ADJUST_COND", "N");
        containingFolder.addAttribute("IND_CYCLIC", "S");
        containingFolder.addAttribute("APPL_TYPE", "OS");
        containingFolder.addAttribute("CYCLIC_TOLERANCE", "0");
        containingFolder.addAttribute("CYCLIC_TYPE", "C");
        containingFolder.addAttribute("REMOVEATONCE", "N");
        containingFolder.addAttribute("DAYSKEEPINNOTOK", "0");
        this.generateEverydayRbc(containingFolder);
        this.addRbcRefOfJobsToContainingFolder(containingFolder);
        containingFolder.addMessage(new NewMessage("INF19000", new String[]{containingFolder.getName()}));
    }

    private void addRbcRefOfJobsToContainingFolder(FolderXmlEntity containingFolder) {
        List children = containingFolder.getChildren();
        HashMap<String, XmlElement> rbcToInsert = new HashMap<String, XmlElement>();
        for (IWorkspaceEntity iWorkspaceEntity : children) {
            if (iWorkspaceEntity.getType() != SchedEntity.TYPE.JOB) continue;
            BaseXmlEntity jobbxe = (BaseXmlEntity)iWorkspaceEntity;
            List rbcElements = jobbxe.getSubElements("RULE_BASED_CALENDARS");
            for (XmlElement rbc : rbcElements) {
                String rbcName = rbc.getAttribute("NAME");
                jobbxe.addMessage(new NewMessage("INF19003", new String[]{iWorkspaceEntity.getName(), containingFolder.getName(), rbcName}));
                rbcToInsert.put(rbcName, rbc);
            }
        }
        for (Map.Entry entry : rbcToInsert.entrySet()) {
            XmlElement rbcXmlElement = (XmlElement)entry.getValue();
            Element rbcElement = rbcXmlElement.getElement();
            Element elementToInsert = this.generateElement("RULE_BASED_CALENDAR");
            elementToInsert.setAttribute("NAME", rbcElement.getAttribute("NAME"));
            elementToInsert.setAttribute("LEVEL", "Y");
            containingFolder.addElement(new XmlElement(elementToInsert));
        }
    }

    private void generateEverydayRbc(FolderXmlEntity containingFolder) {
        Element rbc = this.generateElement("RULE_BASED_CALENDAR");
        rbc.setAttribute("NAME", "EVERYDAY");
        rbc.setAttribute("MAXWAIT", "00");
        rbc.setAttribute("DAYS_AND_OR", "O");
        rbc.setAttribute("JAN", "1");
        rbc.setAttribute("FEB", "1");
        rbc.setAttribute("MAR", "1");
        rbc.setAttribute("APR", "1");
        rbc.setAttribute("MAY", "1");
        rbc.setAttribute("JUN", "1");
        rbc.setAttribute("JUL", "1");
        rbc.setAttribute("AUG", "1");
        rbc.setAttribute("SEP", "1");
        rbc.setAttribute("OCT", "1");
        rbc.setAttribute("NOV", "1");
        rbc.setAttribute("DEC", "1");
        rbc.setAttribute("SHIFT", "Ignore Job");
        rbc.setAttribute("RETRO", "0");
        rbc.setAttribute("DAYS", "ALL");
        rbc.setAttribute("LEVEL", "N");
        containingFolder.addElement(new XmlElement(rbc));
    }

    private Element generateElement(String elementName) {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement(elementName);
        return root;
    }
}

