/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.dataimport;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.dataimport.ListEntry;
import com.bmc.ctmconvert.dataimport.TextInputEntry;
import com.bmc.ctmconvert.dataimport.VendorImporter;
import com.bmc.ctmconvert.flowupdater.dataimport.FlowUpdaterDirectoryFileImporter;
import com.bmc.ctmconvert.flowupdater.dataimport.FlowUpdaterItemImporter;
import com.bmc.ctmconvert.flowupdater.dataimport.FlowUpdaterParamsImporter;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.xml.sax.SAXException;

public class FlowUpdaterVendorImporter
extends VendorImporter {
    public FlowUpdaterVendorImporter(ImportEntryList entries, File targetDir) {
        super(entries, targetDir.toPath());
    }

    public Progressable.ProgressStatus performImport() {
        FlowUpdaterItemImporter fileImporter = null;
        for (ImportEntry importEntry : this.entries) {
            fileImporter = this.doImprot(fileImporter, importEntry);
        }
        this.setStatus(fileImporter.getStatus());
        return this.getStatus();
    }

    private FlowUpdaterItemImporter doImprot(FlowUpdaterItemImporter itemImporter, ImportEntry importEntry) {
        ImporterType entryType = importEntry.getType();
        switch (entryType) {
            case List: {
                itemImporter = this.handleListType(importEntry);
                break;
            }
            case TextInput: {
                itemImporter = this.handleInputTextType(importEntry);
                break;
            }
            case SubSectionTitle: {
                this.handleSubSectionTitle(itemImporter, importEntry);
                break;
            }
            default: {
                Path sourcePath = Paths.get(importEntry.getSourceFullName(), new String[0]);
                itemImporter = new FlowUpdaterDirectoryFileImporter(sourcePath.toFile(), this.targetDir.toFile(), importEntry);
                if (!importEntry.getTitle().equals("Control-M data to insert") || this.isValidSkelaton(sourcePath)) break;
                itemImporter.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
            }
        }
        itemImporter.noProgressBarRun();
        if (itemImporter.getStatus() != Progressable.ProgressStatus.ENDED_SUCCESS) {
            this.setStatus(itemImporter.getStatus());
        }
        return itemImporter;
    }

    private boolean isValidSkelaton(Path sourcePath) {
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(Files.newInputStream(sourcePath, new OpenOption[0]));
        }
        catch (IOException | SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        XmlElement xmlElement = loader.getXmlElement();
        if (!xmlElement.getAllDecnedElementByName("SUB_FOLDER").isEmpty() || !xmlElement.getAllDecnedElementByName("SUB_TABLE").isEmpty()) {
            ProcessAlertsManager.instance().addMessage("The Control-M data supplied in the \"Control-M data to insert\" field contains a Sub Folder entity.\nCurrently this is not supported by the Conversion tool.\nPlease update the Control-M data you want to insert and reload the data.");
            return false;
        }
        return true;
    }

    private void handleSubSectionTitle(FlowUpdaterItemImporter fileImporter, ImportEntry importEntry) {
        List importEntryChildren = importEntry.getImportEntryChildren();
        for (ImportEntry importEntryChild : importEntryChildren) {
            this.doImprot(fileImporter, importEntryChild);
        }
    }

    private FlowUpdaterItemImporter handleInputTextType(ImportEntry importEntry) {
        String valueFromTextInput = ((TextInputEntry)importEntry).getInputTextValue();
        Path sourcePath = Paths.get(importEntry.getDestinationFileName(), new String[0]);
        String value = "<SearchValue Value=\"" + GlobalFunctions.EncodeXMLString((String)valueFromTextInput) + "\" />";
        FlowUpdaterParamsImporter inputTextItemImporter = new FlowUpdaterParamsImporter(sourcePath.toFile(), this.targetDir.toFile(), value);
        return inputTextItemImporter;
    }

    private FlowUpdaterItemImporter handleListType(ImportEntry importEntry) {
        String selecteValue = ((ListEntry)importEntry).getSelectedValue();
        Path sourcePath = Paths.get(importEntry.getDestinationFileName(), new String[0]);
        String value = "<ReplaceCriteria Value=\"" + GlobalFunctions.EncodeXMLString((String)selecteValue) + "\" />";
        FlowUpdaterParamsImporter listItemImporter = new FlowUpdaterParamsImporter(sourcePath.toFile(), this.targetDir.toFile(), value);
        return listItemImporter;
    }
}

