/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.dataimport;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.flowupdater.dataimport.FlowUpdaterItemImporter;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;

public class FlowUpdaterParamsImporter
extends FlowUpdaterItemImporter {
    String value;
    File destinationFile;
    File srcFile;

    public FlowUpdaterParamsImporter(File srcFile, File targetDir, String value) {
        this.value = value;
        this.destinationFile = targetDir;
        this.srcFile = srcFile;
    }

    @Override
    public void noProgressBarRun() {
        this.setStatus(Progressable.ProgressStatus.RUNNING);
        this.generateFile();
    }

    private void generateFile() {
        if (this.srcFile == null || this.destinationFile == null || this.value == null) {
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
        } else {
            Path sourcePath = Paths.get(this.destinationFile.getPath() + "/" + this.srcFile.getName(), new String[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(sourcePath, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                writer.write(this.value);
                this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
            }
            catch (Exception e) {
                this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
                ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to copy '%s'", this.destinationFile.getName()), e);
            }
        }
    }
}

