/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.data.HeaderData;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceData;
import java.util.Map;
import java.util.function.Predicate;

public class FlowUpdaterWorkspaceDataCreator {
    private Workspace ws;
    DataObject dataObject;

    public FlowUpdaterWorkspaceDataCreator(DataObject dataObj, Workspace workspace) {
        this.ws = workspace;
        this.dataObject = dataObj;
    }

    public void act() {
        this.dataObject.stream().filter(this.isHeader()).forEach(this::generateData);
    }

    private Predicate<DataEntity> isHeader() {
        return de -> de.getData().getDataType().equals("HEADER");
    }

    private void generateData(DataEntity de) {
        HeaderData headerData = (HeaderData)de.getData();
        String headername = headerData.getName();
        Map<String, String> headerAttributes = headerData.getHeaderAttributes();
        WorkspaceData workspaceData = new WorkspaceData(headername, headerAttributes);
        this.ws.addWorkspaceData((IWorkspaceData)workspaceData);
    }
}

