/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.convertor.actions.JobsCreator;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterAttrOfXmlElement;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterJobPredicate;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterloadDeToWs;
import com.bmc.ctmconvert.flowupdater.data.JobData;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class FlowUpdaterJobCreator
implements JobsCreator {
    private DataObject dataObject;
    private IWorkspace ws;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public FlowUpdaterJobCreator(DataObject dataObject, IWorkspace ws, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.dataObject = dataObject;
        this.ws = ws;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
    }

    public void act() {
        jobCreator jobCreator2 = new jobCreator();
        FlowUpdaterJobPredicate jobPredicate = new FlowUpdaterJobPredicate();
        this.dataObject.stream().filter(jobPredicate).forEach(jobCreator2);
        List<BaseXmlEntity> jobs = jobCreator2.getJobs();
        for (BaseXmlEntity job : jobs) {
            this.ws.addJob((IWorkspaceEntity)job);
        }
    }

    public class jobCreator
    implements Consumer<DataEntity> {
        List<BaseXmlEntity> jobs = new ArrayList<BaseXmlEntity>();

        @Override
        public void accept(DataEntity de) {
            this.generateJob(de);
        }

        private void generateJob(DataEntity de) {
            WorkspaceId wsID = new WorkspaceId();
            FlowUpdaterJobCreator.this.dataEntityToWorkspaceEntityMap.put(de.getId(), wsID);
            String name = this.getJobName(de);
            JobData jobData = (JobData)de.getData();
            FlowUpdaterAttrOfXmlElement attrOfXmlElement = new FlowUpdaterAttrOfXmlElement(jobData.getJobXmlElement());
            BaseXmlEntity wsJob = new BaseXmlEntity(wsID, name, attrOfXmlElement.getXmlTagName());
            FlowUpdaterloadDeToWs flowUpdaterloadDeToWs = new FlowUpdaterloadDeToWs();
            flowUpdaterloadDeToWs.loadDeToWs(attrOfXmlElement, wsJob);
            this.jobs.add(wsJob);
        }

        private String getJobName(DataEntity dataEntity) {
            return dataEntity.getAttributes().findFirst("JOB_NAME").orElse("");
        }

        public List<BaseXmlEntity> getJobs() {
            ArrayList<BaseXmlEntity> ret = new ArrayList<BaseXmlEntity>(this.jobs);
            return ret;
        }
    }
}

