/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.convertor.actions.HierarchyCreator;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.Folder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public class FlowUpdaterHierarchyCreator
implements HierarchyCreator {
    private Workspace ws;
    private DataObject dataObject;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public FlowUpdaterHierarchyCreator(DataObject dataObject, Workspace workspace, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.ws = workspace;
        this.dataObject = dataObject;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
    }

    public void act() {
        this.dataObject.stream().filter(this.isFolder()).forEach(this::addJobsToFolder);
    }

    private void addJobsToFolder(DataEntity folder) {
        List jobs = this.dataObject.getChildrenOf(folder, this.isValidJob());
        this.addConvertedJobsToFolder(jobs, folder);
    }

    private void addConvertedJobsToFolder(List<DataEntity> jobs, DataEntity folder) {
        Folder wsFolder = this.getEquivalentFolder(folder);
        for (DataEntity deJob : jobs) {
            IWorkspaceEntity wsJob = this.getEquivalentCtmEntity(deJob);
            if (wsJob == null) continue;
            this.ws.insertChildToFolder(wsJob, wsFolder);
        }
    }

    private Folder getEquivalentFolder(DataEntity folder) {
        IWorkspaceEntity wsFolder = this.getEquivalentCtmEntity(folder);
        if (!(wsFolder instanceof Folder)) {
            throw new CannotInsertToJobsException(folder);
        }
        return (Folder)wsFolder;
    }

    private IWorkspaceEntity getEquivalentCtmEntity(DataEntity de) {
        WorkspaceId ctmId = this.dataEntityToWorkspaceEntityMap.get(de.getId());
        IWorkspaceEntity ret = this.ws.getEntityByID(ctmId);
        return ret;
    }

    private Predicate<DataEntity> isValidJob() {
        return dataEntity -> true;
    }

    private Predicate<DataEntity> isFolder() {
        return de -> de.getData().getDataType().equals("FOLDER");
    }

    public class CannotInsertToJobsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CannotInsertToJobsException(DataEntity folder) {
            super("attempt to insert jobs to non appropiate Entity.\n the equivalent entity is not a folder.\n the source entity is :\n  " + folder.toString());
        }
    }
}

