/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.convertor.AbstractConvertor;
import com.bmc.ctmconvert.convertor.actions.FoldersCreator;
import com.bmc.ctmconvert.convertor.actions.HierarchyCreator;
import com.bmc.ctmconvert.convertor.actions.JobsCreator;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.convertor.ConverionInjectionMode;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterFolderCreator;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterHierarchyCreator;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterJobCreator;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterJobPredicate;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterWorkspaceDataCreator;
import com.bmc.ctmconvert.flowupdater.convertor.HandleMatchedJobsToJob;
import com.bmc.ctmconvert.flowupdater.convertor.HandleMatchedJobsToSubfolder;
import com.bmc.ctmconvert.flowupdater.data.JobData;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterJobMeetCriteria;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterSingleJobInjector;
import com.bmc.ctmconvert.flowupdater.inject.JobInjector;
import com.bmc.ctmconvert.flowupdater.predicate.JobPredicate;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.Workspace;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FlowUpdaterConvertor
extends AbstractConvertor {
    private FlowUpdaterJobMeetCriteria flowUpdaterJobMeetCriteria;
    private DataObject injectionDataObject;

    public FlowUpdaterConvertor(DataObject dataObject, Workspace workspace, FlowUpdaterJobMeetCriteria jobCriteria, DataObject injectionDataObject) {
        super(dataObject, workspace);
        this.flowUpdaterJobMeetCriteria = jobCriteria;
        this.injectionDataObject = injectionDataObject;
    }

    public void convert() {
        super.convert();
        this.dataHandling();
        List<DataEntity> matchedJobs = this.getMatchedJobs();
        this.handleMatchedJobs(matchedJobs);
    }

    private List<DataEntity> getMatchedJobs() {
        JobPredicate jobPredicate = new JobPredicate();
        List<DataEntity> matchedJobs = this.dataObject.stream().filter(jobPredicate).filter(de -> this.flowUpdaterJobMeetCriteria.isJobMeetCriteria((DataEntity)de)).collect(Collectors.toList());
        return matchedJobs;
    }

    private void dataHandling() {
        new FlowUpdaterWorkspaceDataCreator(this.dataObject, this.workspace).act();
    }

    private void handleMatchedJobs(List<DataEntity> matchedJobs) {
        ConverionInjectionMode converionInjectionMode = new ConverionInjectionMode(this.injectionDataObject);
        if (converionInjectionMode.isSingleMode()) {
            FlowUpdaterJobPredicate jobPredicate = new FlowUpdaterJobPredicate();
            Optional<DataEntity> optInjectedJobDataEntry = this.injectionDataObject.stream().filter(jobPredicate).findFirst();
            if (optInjectedJobDataEntry.isPresent()) {
                JobData injectedJobDataEntry = (JobData)optInjectedJobDataEntry.get().getData();
                HandleMatchedJobsToJob handleMatchedJobsToJob = new HandleMatchedJobsToJob(this.workspace, injectedJobDataEntry, this.dataEntityToWorkspaceEntityMap);
                handleMatchedJobsToJob.handle(matchedJobs, new JobInjector(), new FlowUpdaterSingleJobInjector());
            }
        } else {
            HandleMatchedJobsToSubfolder handleMatchedJobsToSubfolder = new HandleMatchedJobsToSubfolder(this.workspace, this.injectionDataObject, this.dataEntityToWorkspaceEntityMap);
            handleMatchedJobsToSubfolder.handle(matchedJobs);
        }
    }

    public FoldersCreator getFoldersCreator() {
        return new FlowUpdaterFolderCreator(this.dataObject, this.workspace, this.dataEntityToWorkspaceEntityMap);
    }

    public HierarchyCreator createHierarchy() {
        return new FlowUpdaterHierarchyCreator(this.dataObject, this.workspace, this.dataEntityToWorkspaceEntityMap);
    }

    public JobsCreator getJobsCreator() {
        return new FlowUpdaterJobCreator(this.dataObject, (IWorkspace)this.workspace, this.dataEntityToWorkspaceEntityMap);
    }
}

