/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CriteriaGetter;
import com.bmc.ctmconvert.DraftWriterSupplier;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponentSection;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.DraftWriter;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.convertor.Convertor;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.dataimport.DynamicDataImportPanel;
import com.bmc.ctmconvert.dataimport.EntriesImporter;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.flowupdater.assessmentreport.FlowUpdaterAssessmenrReport;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterConvertor;
import com.bmc.ctmconvert.flowupdater.dataimport.FlowUpdaterVendorImporter;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterJobMeetCriteria;
import com.bmc.ctmconvert.flowupdater.inject.JobMeetsAttributeCriteria;
import com.bmc.ctmconvert.flowupdater.inject.JobMeetsVariableCriteria;
import com.bmc.ctmconvert.flowupdater.reader.FlowUpdaterDataReader;
import com.bmc.ctmconvert.flowupdater.xmlwriter.FlowUpdaterDraftWriter;
import com.bmc.ctmconvert.interfaces.ConversionReader;
import com.bmc.ctmconvert.interfaces.DefaultVendorData;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.sourceDefinitions.GeneralSourceDefinitions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class AppData
extends DefaultVendorData
implements DraftWriterSupplier {
    private Workspace workspace;

    public String getName() {
        return "FlowUpdater";
    }

    public String getDisplayName() {
        return "Control-M OS to Application Jobs";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Other;
    }

    public DataImportVendor getDataImport() {
        return new DynamicDataImportPanel(this.generateImporter(), "LOAD_DATA_FLOWUPDATER");
    }

    public CliImporter getCLIImporter() {
        return null;
    }

    public BasePanel getAssessmentReport(String path) {
        FlowUpdaterJobMeetCriteria criteria = this.getCriteria();
        return new FlowUpdaterAssessmenrReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, "", criteria);
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
        DataObject dataObject = this.getDataObject();
        this.workspace = new Workspace();
        FlowUpdaterJobMeetCriteria flowUpdaterJobMeetCriteria = this.getCriteria();
        try {
            FileInputStream flowToInjectStream = new FileInputStream(new File(ConversionEntitiesService.getCurrentProjectDataDirectory() + "\\flowToInject.xml"));
            FlowUpdaterDataReader injectionReader = new FlowUpdaterDataReader(flowToInjectStream);
            DataObject injectionDataObject = injectionReader.read();
            FlowUpdaterConvertor convertor = new FlowUpdaterConvertor(dataObject, this.workspace, flowUpdaterJobMeetCriteria, injectionDataObject);
            GeneralSourceDefinitions sourceDefinitions = new GeneralSourceDefinitions((Convertor)convertor, (IWorkspace)this.workspace);
            convertor.addSourceDefinitions(sourceDefinitions);
            return sourceDefinitions;
        }
        catch (FileNotFoundException e) {
            ConversionLogger.getLogger().throwing(((Object)((Object)this)).getClass().getName(), "getflowToInjectStream", e);
            throw new XmlNotFoundExeption(e);
        }
    }

    public BaseComponentSection.Grid getVersionGridForConversionSettings(BaseField DSContromMField, BaseField ZOSControlMField, BaseComponentSection componentSection, BaseComponentSection.Grid addHorizontalGap, BaseComboBox versionsDrop, BaseTextField DSContromM, BaseTextField ZOSControlM) {
        return addHorizontalGap;
    }

    private FlowUpdaterJobMeetCriteria getCriteria() {
        CriteriaGetter getter = new CriteriaGetter(Params.instance().getDatasourcePath());
        String field = getter.getSearchCriteria();
        String tagName = getter.getTagName();
        String replaceValue = getter.getValue();
        if (tagName.equals("Variable")) {
            return new JobMeetsVariableCriteria(replaceValue, field);
        }
        return new JobMeetsAttributeCriteria(replaceValue, field);
    }

    protected ConversionReader getReader() {
        String inputFile = ConversionEntitiesService.getCurrentProjectDataDirectory() + "\\ctmInputData.xml";
        try {
            return new FlowUpdaterDataReader(new FileInputStream(new File(inputFile)));
        }
        catch (FileNotFoundException e) {
            ConversionLogger.getLogger().throwing(((Object)((Object)this)).getClass().getName(), "getReader", e);
            throw new InputFileNotFoundException(inputFile, e);
        }
    }

    private EntriesImporter generateImporter() {
        ImportEntryList entries = this.getImportEntries();
        Path destinationPath = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
        File targetDir = destinationPath.toFile();
        return new FlowUpdaterVendorImporter(entries, targetDir);
    }

    public DraftWriter getDraftWriter(DataAccumulator dataAccumulator) {
        return new FlowUpdaterDraftWriter(this.workspace, dataAccumulator);
    }

    public Optional<DataObject> getInjectionDataObject() {
        Optional<DataObject> injectionDataObject = Optional.empty();
        try {
            FileInputStream flowToInjectStream = new FileInputStream(new File(ConversionEntitiesService.getCurrentProjectDataDirectory() + "\\flowToInject.xml"));
            FlowUpdaterDataReader injectionReader = new FlowUpdaterDataReader(flowToInjectStream);
            injectionDataObject = Optional.of(injectionReader.read());
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return injectionDataObject;
    }

    public boolean shouldBeLoaded() {
        return SettingsBooleanKeys.isOnPremise();
    }

    public class XmlNotFoundExeption
    extends RuntimeException {
        private static final long serialVersionUID = 2906243756642752537L;

        public XmlNotFoundExeption(FileNotFoundException e) {
            super("XML to inject is missing" + e.getMessage());
        }
    }

    public class InputFileNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InputFileNotFoundException(String inputFile, Exception e) {
            super("input XML file not found" + inputFile, e);
        }
    }
}

