/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.utils;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class TaskEmailUtils {
    public static boolean isTaskEmail(XmlElement task, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return "TASK_EMAIL".equals(ZenaXmlUtils.getTagNameFromTaskDefinition(task, entitiesDefinitionsManager));
    }

    public static boolean isTaskEmail(Element task, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return TaskEmailUtils.isTaskEmail(XmlElement.ofNullable((Element)task), entitiesDefinitionsManager);
    }

    public static boolean shouldSkipEmailTask(Element source, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return TaskEmailUtils.shouldSkipEmailTask(XmlElement.ofNullable((Element)source), entitiesDefinitionsManager);
    }

    public static boolean shouldSkipEmailTask(XmlElement source, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return TaskEmailUtils.isEmailTaskWithTrivialConditionStructure(source, entitiesDefinitionsManager) && !TaskEmailUtils.someNextTaskIsAnEmailTask(source, entitiesDefinitionsManager) && !TaskEmailUtils.someNextTaskIsA_Depencency(source);
    }

    private static boolean someNextTaskIsAnEmailTask(XmlElement source, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return ZenaXmlUtils.getNextTasks(source).anyMatch(nextTask -> TaskEmailUtils.isTaskEmail(nextTask, entitiesDefinitionsManager));
    }

    private static boolean someNextTaskIsA_Depencency(XmlElement source) {
        return ZenaXmlUtils.getNextTasks(source).anyMatch(nextTask -> ZenaXmlUtils.isDependency(nextTask));
    }

    public static boolean isEmailTaskWithTrivialConditionStructure(XmlElement source, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return TaskEmailUtils.isTaskEmail(source, entitiesDefinitionsManager) && ZenaXmlUtils.hasTrivialConditionStructure(source) && SettingsBooleanKeys.ZENA_EMAIL_TASK_TO_ONDO.isEnabled();
    }

    public static Stream<XmlElement> getNextSkippedEmailTasks(Element entityProcessData, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return ZenaXmlUtils.getNextTasks(entityProcessData).filter(source -> TaskEmailUtils.shouldSkipEmailTask(source, entitiesDefinitionsManager));
    }
}

