/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.sql_query;

import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlTaskConvertor;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.StoredProc;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.StoredProcedureParameter;

public class StoredProcConvertor {
    public static final String DEFAULT_SCHEMA = "dbo";
    private final SqlTaskConvertor sqlTaskConvertor;
    private StoredProc storedProc;
    private ZenaJob job;
    private ZenaVariablesHandler zenaVariablesHandler;

    public StoredProcConvertor(StoredProc storedProc, ZenaJob job, ZenaVariablesHandler zenaVariablesHandler) {
        this.storedProc = storedProc;
        this.job = job;
        this.zenaVariablesHandler = zenaVariablesHandler;
        this.sqlTaskConvertor = new SqlTaskConvertor(storedProc, job, zenaVariablesHandler);
    }

    public void convert() {
        this.sqlTaskConvertor.setDefaultValues("Stored Procedure");
        this.sqlTaskConvertor.convert();
        this.convertSchema();
        this.convertStoredProcedureName();
        this.convertParameters();
    }

    private void convertSchema() {
        this.job.addAutoEdits("%%DB-STP_SCHEM", DEFAULT_SCHEMA);
    }

    private void convertStoredProcedureName() {
        this.job.addAutoEdits("%%DB-STP_NAME", this.storedProc.STOREDPROCEDURE);
    }

    private void convertParameters() {
        int parameterIndex = 1;
        for (StoredProcedureParameter parameter : this.storedProc.parameters) {
            this.job.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_NAME", parameterIndex), parameter.NAME);
            this.job.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_TYPE", parameterIndex), this.convertType(parameter.EXTTYPE));
            this.job.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_DIRECTION", parameterIndex), this.convertDirection(parameter.DIRECTION));
            if (this.shouldHaveValue(parameter)) {
                this.job.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_VALUE", parameterIndex), this.convertValue(parameter.VALUE));
            }
            ++parameterIndex;
        }
    }

    private String convertValue(String value) {
        return this.zenaVariablesHandler.annotateVariables(value);
    }

    private String convertType(String exttype) {
        switch (exttype) {
            case "INTEGER": {
                return "int";
            }
            case "VARCHAR": {
                return "varchar";
            }
            case "VARWCHAR": {
                return "varchar";
            }
            case "DBTIMESTAMP": {
                return "text";
            }
            case "GUID": {
                return "text";
            }
            case "SMALLINT": {
                return "int";
            }
            case "DATE": {
                return "text";
            }
            case "NUMBER": {
                return "int";
            }
        }
        return exttype;
    }

    private boolean shouldHaveValue(StoredProcedureParameter parameter) {
        return !parameter.DIRECTION.equals("RETURNVALUE");
    }

    private String convertDirection(String direction) {
        switch (direction) {
            case "IN": {
                return "In";
            }
            case "OUT": {
                return "Out";
            }
            case "IN/OUT": {
                return "InOut";
            }
            case "RETURNVALUE": {
                return "Return";
            }
        }
        return direction;
    }
}

