/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.script;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.folders.ZenaFolderHierarchy;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptHandler;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptVariable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScriptTask
extends ZenaTask {
    public static final String VBS = ".vbs";
    public static final String PY = ".py";
    public static final String PL = ".pl";
    public static final String PS_1 = ".ps1";
    public static final String JS = ".js";
    private final Element processDefinition;
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;
    private final FileSystem fileSystem;
    String fileElementText;
    String baseName = "";
    String fileName = "";
    private String taskType;
    private final boolean isEmbeddedScript;
    private String script;
    private boolean writeScriptToExternalFile;
    private ScriptHandler scriptHandler;
    private final RulesDataSet rules;

    private ScriptTask(Element entityDefinition, Element processDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager, FileSystem fileSystem, RulesDataSet rules) {
        super(entityDefinition, job);
        this.processDefinition = processDefinition;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.fileSystem = fileSystem;
        this.writeScriptToExternalFile = false;
        this.taskType = "Job";
        this.isEmbeddedScript = this.isEmbeddedScript();
        this.rules = rules;
    }

    public static ScriptTask createScriptTask(Element entityDefinition, Element processDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager, RulesDataSet rules) {
        return ScriptTask.createScriptTask(entityDefinition, processDefinition, job, entitiesDefinitionsManager, FileSystems.getDefault(), rules);
    }

    static ScriptTask createScriptTask(Element entityDefinition, Element processDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager, FileSystem fileSystem, RulesDataSet rules) {
        ScriptTask scriptTask = new ScriptTask(entityDefinition, processDefinition, job, entitiesDefinitionsManager, fileSystem, rules);
        scriptTask.computeTaskType();
        return scriptTask;
    }

    private void computeTaskType() {
        if (this.isEmbeddedScript) {
            this.script = this.convertScript();
            if (this.writeScriptToExternalFile) {
                this.taskType = "Command";
            }
        }
    }

    @Override
    protected void convertTaskType() {
        this.setScriptType();
        this.addFolderOidVariable();
        if (this.isEmbeddedScript) {
            if (this.writeScriptToExternalFile) {
                this.toCommandJob();
            } else {
                this.toEmbeddedScript(this.script);
            }
        } else {
            this.toScriptJob();
        }
    }

    private void addFolderOidVariable() {
        this.job.addAutoEdits("%%FOLDER_OID", "%%FOLDER_OID");
    }

    private void toScriptJob() {
        this.fileElementText = XmlElement.ofNullable((Element)this.getEntityAttributes()).getValueOfFirstChildElementByName("FILE");
        this.initializeFileNameAndFilePath();
        this.setMemLib(this.baseName);
    }

    private void toCommandJob() {
        this.taskType = "Command";
        String scriptFullPath = this.fileSystem.getPath(this.getScriptTargetDirectoryFromRule(this.scriptHandler.getExternalPathRuleName()), new String[0]).resolve(this.getFileName()).toString();
        this.setCmdLine(this.scriptHandler.getCommandPath() + GlobalFunctions.AddQuotes((String)scriptFullPath));
    }

    private boolean isScriptToCommandJob() {
        return "VBSCRIPT_TO_COMMAND_JOB".equals(this.job.getRules().getStringRule("Zena rules", new String[]{"CONVERT_VBSCRIPT_TO_EXTERNAL_FILE"}));
    }

    private String getScriptTargetDirectoryFromRule(String externalDirectoryPathRuleName) {
        return this.job.getRules().getStringRule("Zena rules", new String[]{externalDirectoryPathRuleName});
    }

    private void toEmbeddedScript(String script) {
        this.properties.put("INSTREAM_JCL", script);
    }

    void initializeFileNameAndFilePath() {
        if (this.setPathParts("/") || this.setPathParts("\\") || this.setPathParts("]", index -> index != -1 && index != this.fileElementText.length() - 1)) {
            return;
        }
        if (this.containsMultipleVariableReferences()) {
            this.setPartPathByIndex(this.fileElementText.lastIndexOf(91));
        } else {
            this.fileName = this.fileElementText;
            this.baseName = "/";
        }
    }

    private boolean containsMultipleVariableReferences() {
        int lastOpenVariableIndex = this.fileElementText.lastIndexOf(91);
        int lastCloseVariableIndex = this.fileElementText.lastIndexOf(93);
        return StringUtils.countMatches((CharSequence)this.fileElementText, (CharSequence)"]") != 1 && lastOpenVariableIndex != -1 && lastCloseVariableIndex == this.fileElementText.length() - 1;
    }

    private boolean setPathParts(String delimiter) {
        return this.setPathParts(delimiter, index -> true);
    }

    private boolean setPathParts(String delimiter, IntPredicate operator) {
        boolean delimiterFound;
        int lastDelimiterIndex = this.fileElementText.lastIndexOf(delimiter);
        boolean bl = delimiterFound = lastDelimiterIndex != -1 && operator.test(lastDelimiterIndex);
        if (delimiterFound) {
            this.setPartPathByIndex(lastDelimiterIndex + 1);
        }
        return delimiterFound;
    }

    private void setPartPathByIndex(int lastLinuxSeparator) {
        this.baseName = this.fileElementText.substring(0, lastLinuxSeparator);
        this.fileName = this.fileElementText.substring(lastLinuxSeparator);
    }

    private void setScriptType() {
        String jcl = this.isEmbeddedScript && !this.writeScriptToExternalFile ? "Y" : "N";
        this.properties.put("USE_INSTREAM_JCL", jcl);
    }

    private boolean isEmbeddedScript() {
        return "NO".equals(XmlElement.ofNullable((Element)this.getEntityAttributes()).getValueOfFirstChildElementByName("USEFILE")) || "SCRIPT".equals(XmlElement.ofNullable((Element)this.getEntityDefinition()).getTagName());
    }

    private String getFileNameExtension() {
        NodeList lang = this.getEntityAttributes().getElementsByTagName("LANGUAGE");
        String fileNameExtension = ".cmd";
        if (lang.getLength() > 0) {
            String language;
            switch (language = lang.item(0).getTextContent()) {
                case "JavaScript": {
                    fileNameExtension = JS;
                    break;
                }
                case "PowerShell": {
                    fileNameExtension = PS_1;
                    break;
                }
                case "PythonScript": {
                    fileNameExtension = PY;
                    break;
                }
                case "VBScript": {
                    fileNameExtension = VBS;
                    break;
                }
                case "PerlScript": {
                    fileNameExtension = PL;
                    break;
                }
            }
        }
        return fileNameExtension;
    }

    static boolean shouldAlwaysAddItemUid(RulesDataSet rules) {
        return !ZenaDefs.addZenaItemUidOnlyWhenNeeded(rules);
    }

    private void addMissingVariableToSmartFolder(ScriptVariable variable) {
        String itemUid = this.job.getItemUid();
        String variableNameWithoutPrefix = this.buildVariableName("", variable);
        if (ScriptTask.isMissingVariable(this.job, variableNameWithoutPrefix)) {
            if (!ScriptTask.shouldAlwaysAddItemUid(this.rules)) {
                this.job.getSmartFolder().addAutoEdits(variableNameWithoutPrefix, "");
            } else if (variable.isLocalVariable()) {
                String variableNameWithPrefix = this.buildVariableName(itemUid + "_", variable);
                this.job.getSmartFolder().getAutoedits().putIfAbsent(variableNameWithPrefix, "");
            } else {
                this.job.getSmartFolder().addAutoEdits(variableNameWithoutPrefix, "");
            }
        } else if (variable.isLocalVariable() && !this.job.getSmartFolder().getVariablesMapping().hasJobWithVariable(this.job.getJobName(), variable.getName())) {
            String variableNameWithPrefix = this.buildVariableName(itemUid + "_", variable);
            this.job.getSmartFolder().addAutoEdits(variableNameWithPrefix, "");
        }
    }

    private String convertScript() {
        this.scriptHandler = ScriptHandler.createScriptHandler(this.getFileNameExtension(), this.getScript(), this.zenaVariablesHandler, this.rules);
        String modifiedScript = this.scriptHandler.handle();
        this.scriptHandler.getMessageIds().forEach(messageId -> Reporter.addMessage(this.job.getMessages(), (String)messageId, (String)this.job.getJobName(), (String[])new String[]{this.job.getJobName(), this.job.getOriginalJobName()}));
        this.scriptHandler.getVariablesFromScript().stream().filter(ScriptVariable::isSystemVariable).forEach(variable -> this.addScriptVariableToJob((ScriptVariable)variable, this.job));
        this.scriptHandler.getVariablesFromScript().stream().filter(variable -> variable.isProcessVariable() || variable.isLocalVariable()).filter(ScriptVariable::isVariableSet).forEach(this::addMissingVariableToSmartFolder);
        this.writeScriptToExternalFile = this.shouldWriteScriptToFile(this.scriptHandler);
        return this.writeScriptToFileIfNeeded(modifiedScript);
    }

    static boolean isMissingVariable(ZenaJob job, String variableName) {
        return !job.getSmartFolder().getAutoedits().containsKey(variableName);
    }

    private String buildVariableName(String prefix, ScriptVariable variable) {
        String variableName = prefix + variable.getName();
        return "%%" + this.zenaVariablesHandler.validateVariableName(variableName);
    }

    private boolean writeScriptToExternalFileIsEnabled() {
        return this.isScriptToCommandJob();
    }

    private boolean shouldWriteScriptToFile(ScriptHandler scriptHandler) {
        boolean ruleIsEnabled = this.writeScriptToExternalFileIsEnabled();
        return !scriptHandler.isScriptIgnored() && scriptHandler.isSupportedScript() && ruleIsEnabled;
    }

    private void addScriptVariableToJob(ScriptVariable variable, ZenaJob job) {
        String variableName = "%%" + variable.getName();
        this.getScriptVariablePrefix(variable).ifPresent(prefix -> {
            String variableValue = prefix + variable.getName();
            job.addAutoEdits(variableName, variableValue);
        });
    }

    private Optional<String> getScriptVariablePrefix(ScriptVariable variable) {
        Object variablePrefix = null;
        if (variable.isProcessVariable()) {
            variablePrefix = "%%";
        } else if (variable.isSystemVariable()) {
            ZenaFolderHierarchy folderHierarchy = this.entitiesDefinitionsManager.getFolderHierarchy();
            String applicationAbbreviation = this.zenaVariablesHandler.createPoolNameFromApplicationName(Optional.ofNullable(folderHierarchy), XmlElement.ofNullable((Element)this.getEntityDefinition()));
            variablePrefix = "%%\\\\" + applicationAbbreviation + "\\";
        }
        return Optional.ofNullable(variablePrefix);
    }

    private String getScript() {
        NodeList scriptElements = this.getEntityAttributes().getElementsByTagName("SCRIPT");
        String scriptContent = "";
        if (scriptElements.getLength() > 0) {
            scriptContent = scriptElements.item(0).getTextContent();
        }
        ResolveScriptVariable resolveScriptVariable = new ResolveScriptVariable(this.getEntityDefinition(), this.processDefinition, scriptContent);
        return resolveScriptVariable.resolve();
    }

    @Override
    protected void setmemName(ZenaJob job) {
        if (this.isEmbeddedScript) {
            String extension = this.getFileNameExtension();
            String memName = job.getJobName();
            if (memName.length() > 60) {
                memName = memName.substring(0, 60);
            }
            String jobName = memName + extension;
            this.properties.put("MEMNAME", jobName);
        } else {
            this.properties.put("MEMNAME", this.fileName);
        }
    }

    @Override
    public String getControlMTaskType() {
        return this.taskType;
    }

    public String writeScriptToFileIfNeeded(String scriptContent) {
        if (this.writeScriptToExternalFile) {
            try {
                Path directoryPath = this.getScriptDirectory();
                Files.createDirectories(directoryPath, new FileAttribute[0]);
                Path fullPath = directoryPath.resolve(this.getFileName());
                Files.write(fullPath, scriptContent.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return scriptContent;
    }

    private String getFileName() {
        String applicationPrefix = Optional.ofNullable(this.job.getApplication()).filter(s -> !s.isBlank()).map(application -> application + "_").orElse("");
        return GlobalFunctions.toValidFilename((String)"%s%s_%s%s".formatted(applicationPrefix, this.job.getParentName(), this.job.getJobName(), this.getFileNameExtension()));
    }

    private Path getScriptDirectory() {
        String fileNameExtension = this.getFileNameExtension();
        String language = fileNameExtension.equals(VBS) ? "VBScript" : "JavaScript";
        return this.fileSystem.getPath(Globs.TEMP_EVALUATION_DIR, new String[0]).resolve("scripts").resolve(language);
    }

    private static class ResolveScriptVariable {
        private final XmlElement processDefinition;
        private final XmlElement taskDefinition;
        private final String script;

        public ResolveScriptVariable(Element taskDefinition, Element processDefinition, String script) {
            this.processDefinition = XmlElement.ofNullable((Element)processDefinition);
            this.taskDefinition = XmlElement.ofNullable((Element)taskDefinition);
            this.script = script;
        }

        public String resolve() {
            if (this.isScriptFromVariable()) {
                return this.tryGetVariableFrom(this.taskDefinition).orElseGet(() -> this.tryGetVariableFrom(this.processDefinition).orElseGet(() -> this.tryGetVariableFrom(this.getParentProcessDefinition()).orElse(this.script)));
            }
            return this.script;
        }

        private String getVariableName() {
            return Stream.of(this.script.split("\\.")).reduce((left, right) -> right).map(x -> x.replace("]", "")).orElse(this.script);
        }

        private XmlElement getParentProcessDefinition() {
            return this.processDefinition.getParent().getParent();
        }

        private Optional<String> tryGetVariableFrom(XmlElement taskDefinition) {
            XmlElement variables = taskDefinition.getAllDecnedElementByName("VARIABLES").stream().findAny().orElse(XmlElement.nullXmlElement);
            return variables.getAllDirectchildsElement().stream().filter(v -> v.getAttribute("NAME").equals(this.getVariableName()) && !v.getText().isBlank()).map(XmlElement::getText).findAny();
        }

        private boolean isScriptFromVariable() {
            return ZenaVariablesHandler.variablePattern.matcher(this.script).matches();
        }
    }
}

