/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.EmailTask;
import com.bmc.ctmconvert.zena.tasktypes.EmptyTask;
import com.bmc.ctmconvert.zena.tasktypes.FileTask;
import com.bmc.ctmconvert.zena.tasktypes.FlowTask;
import com.bmc.ctmconvert.zena.tasktypes.FtpTask;
import com.bmc.ctmconvert.zena.tasktypes.HttpTask;
import com.bmc.ctmconvert.zena.tasktypes.ProcessDefenitionsTask;
import com.bmc.ctmconvert.zena.tasktypes.SFtpTask;
import com.bmc.ctmconvert.zena.tasktypes.SapTask;
import com.bmc.ctmconvert.zena.tasktypes.SendEventTask;
import com.bmc.ctmconvert.zena.tasktypes.SsisTask;
import com.bmc.ctmconvert.zena.tasktypes.SynchronizerTask;
import com.bmc.ctmconvert.zena.tasktypes.SystemCommandTask;
import com.bmc.ctmconvert.zena.tasktypes.TerminatorTask;
import com.bmc.ctmconvert.zena.tasktypes.TimerRangeTask;
import com.bmc.ctmconvert.zena.tasktypes.TimerTask;
import com.bmc.ctmconvert.zena.tasktypes.UserInputTask;
import com.bmc.ctmconvert.zena.tasktypes.VarDependencyTask;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.tasktypes.data.DataTask;
import com.bmc.ctmconvert.zena.tasktypes.dependency.FileDependencyTask;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptTask;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlAgentTask;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlQueryTask;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.StoredProcTask;
import org.w3c.dom.Element;

public class ZenaTaskFactory {
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;
    private final RulesDataSet rules;

    public ZenaTaskFactory(EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this(entitiesDefinitionsManager, RuleManager.instance().getCurrentRules());
    }

    public ZenaTaskFactory(EntitiesDefinitionsManager entitiesDefinitionsManager, RulesDataSet rules) {
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.rules = rules;
    }

    public ZenaTask createTask(Element entityDefinition, ZenaJob job, Element processDefinition) {
        String entityType;
        return switch (entityType = ZenaTaskFactory.getType(entityDefinition)) {
            case "TASK_EMAIL" -> new EmailTask(entityDefinition, job);
            case "TASK_FILE" -> new FileTask(entityDefinition, job);
            case "TASK_SYSCMD" -> new SystemCommandTask(entityDefinition, job);
            case "TASK_FTP" -> new FtpTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "TASK_SFTP" -> new SFtpTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "TIME_RANGE" -> new TimerRangeTask(entityDefinition, job);
            case "TIMER" -> new TimerTask(entityDefinition, job);
            case "PROCESS" -> new ProcessDefenitionsTask(entityDefinition, job);
            case "TERMINATOR" -> new TerminatorTask(entityDefinition, job);
            case "DATA" -> new DataTask(entityDefinition, job);
            case "FLOW" -> new FlowTask(entityDefinition, job);
            case "SYNCHRONIZER" -> new SynchronizerTask(entityDefinition, job);
            case "SCRIPT", "TASK_SCRIPT", "TASK_SHELL_SCRIPT" -> ScriptTask.createScriptTask(entityDefinition, processDefinition, job, this.entitiesDefinitionsManager, this.rules);
            case "TASK_SQLQUERY" -> new SqlQueryTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "TASK_STORED_PROC" -> new StoredProcTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "TASK_SSIS" -> new SsisTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "TASK_SQL_AGENT_JOB" -> new SqlAgentTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "USER_INPUT" -> new UserInputTask(entityDefinition, job);
            case "VAR_DEPENDENCY" -> new VarDependencyTask(entityDefinition, job, this.entitiesDefinitionsManager);
            case "USEREVENT" -> new SendEventTask(entityDefinition, job, processDefinition, this.entitiesDefinitionsManager);
            case "DEPENDENCY_FILE" -> new FileDependencyTask(entityDefinition, job);
            case "TASK_HTTP" -> new HttpTask(entityDefinition, job);
            case "TASK_SAP" -> new SapTask(entityDefinition, job, this.entitiesDefinitionsManager);
            default -> new EmptyTask(entityDefinition, job);
        };
    }

    private static String getType(Element entityDefinition) {
        return entityDefinition.getTagName();
    }
}

