/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ZenaTask {
    protected ZenaJob job;
    private Optional<String> memLib;
    private Optional<String> cmdLine;
    private Optional<Properties> onStatements;
    private Element entityDefinition;
    protected Map<String, String> properties;
    protected ZenaVariablesHandler zenaVariablesHandler;
    protected String controlMVersion;

    protected ZenaTask(Element entityDefnition, ZenaJob job) {
        this.job = job;
        this.setEntityDefnition(entityDefnition);
        this.memLib = Optional.empty();
        this.cmdLine = Optional.empty();
        this.onStatements = Optional.empty();
        this.properties = new HashMap<String, String>();
        this.zenaVariablesHandler = job.getZenaVariablesHandler();
        this.controlMVersion = Params.instance().getGUIVersion();
    }

    public Element getEntityAttributes() {
        NodeList attributeList;
        if (this.getEntityDefinition() != null && (attributeList = this.getEntityDefinition().getElementsByTagName("ATTRIBUTES")).getLength() > 0) {
            return (Element)attributeList.item(0);
        }
        return null;
    }

    protected abstract void convertTaskType();

    public final void convertTask() {
        String taskType = this.getControlMTaskType();
        if (!this.isEmptyTask()) {
            this.convertTaskType();
            this.memLib.ifPresent(val -> this.job.setMemLib((String)val));
            this.cmdLine.ifPresent(val -> this.job.setCommandLine((String)val));
            this.onStatements.ifPresent(val -> this.job.addOnStmts((Properties)val));
            this.setmemName(this.job);
        }
        if (this.isDummyJob(taskType)) {
            this.properties.put("OWNER", "DUMMYUSR");
        }
        if (this.job.convertToDummyJobs()) {
            taskType = this.convertAllJobsToDummy(this.job, taskType);
        }
        this.properties.put("TASKTYPE", taskType);
        this.setJobProperties(this.job);
    }

    private boolean isDummyJob(String taskType) {
        return taskType.equals("Dummy");
    }

    private String convertAllJobsToDummy(ZenaJob job, String taskType) {
        boolean taskIsDummy = this.isDummyJob(taskType);
        if (!taskIsDummy) {
            job.getAutoedits().put("%%$BMCWAIORIGTYPE", taskType);
        }
        taskType = "Dummy";
        return taskType;
    }

    private void setJobProperties(ZenaJob job) {
        this.properties.forEach(job::addAttribute);
    }

    public String quoteIfNotQuoted(String str) {
        if (str != null && !str.isEmpty() && !str.trim().matches("^\".*\"$")) {
            str = String.format("\"%s\"", str);
        }
        return str;
    }

    public boolean isWindows() {
        return this.job.isWindows();
    }

    protected final void setCmdLine(String cmdLine) {
        this.cmdLine = Optional.ofNullable(cmdLine);
    }

    protected final void setMemLib(String memlib) {
        this.memLib = Optional.ofNullable(memlib);
    }

    protected final void setOnStatements(Properties onStatements) {
        this.onStatements = Optional.ofNullable(onStatements);
    }

    protected final void setProperties(Map<String, String> timeProperties) {
        this.properties.putAll(timeProperties);
    }

    protected void setmemName(ZenaJob job) {
        String memname = job.getJobName();
        if (memname.length() > 60) {
            memname = memname.substring(0, 60);
        }
        memname = String.format("%s%s", memname, this.isWindows() ? ".cmd" : "");
        this.properties.put("MEMNAME", memname);
    }

    public Element getEntityDefinition() {
        return this.entityDefinition;
    }

    public void setEntityDefnition(Element entityDefnition) {
        this.entityDefinition = entityDefnition;
    }

    protected boolean isEmptyTask() {
        return this.getEntityAttributes() == null;
    }

    public abstract String getControlMTaskType();
}

