/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;

public class VarDependencyTask
extends ZenaTask {
    private static final String VARIABLE_NOT_FOUND = "%%VARIABLE_NOT_FOUND";
    private final XmlElement taskDefinition;
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;
    private static final String ITEM = "ITEM";
    private static final String SYSTEM = "SYSTEM";
    private static final String PROCESS = "PROCESS";
    private final Map<String, String> operatorMap = new HashMap<String, String>();

    public VarDependencyTask(Element entityDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefinition, job);
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.taskDefinition = XmlElement.ofNullable((Element)this.getEntityDefinition());
        this.createOperatorMap();
    }

    private void createOperatorMap() {
        this.operatorMap.put("<=", "LEQ");
        this.operatorMap.put("<", "LSS");
        this.operatorMap.put(">", "GTR");
        this.operatorMap.put(">=", "GEQ");
        this.operatorMap.put("=", "EQU");
        this.operatorMap.put("<>", "NEQ");
    }

    @Override
    protected void convertTaskType() {
        String varDependencyValue = this.getVarDependencyValue();
        String variableNameByUid = this.getVariableNameByUid();
        String operator = this.getOperator();
        this.setCmdLine(this.getCmd(variableNameByUid, varDependencyValue, operator));
        this.createOnStatement("*false*", Do.createDoNotOk());
        this.createOnStatement("*true*", Do.createDoOk());
    }

    private void createOnStatement(String code, Do doAction) {
        OnStatement.OnSpecificStatement onStatement = new OnStatement.OnSpecificStatement("*", code);
        onStatement.addDo(doAction);
        this.job.addOnDoStatement((OnStatement)onStatement);
    }

    private String getCmd(String variableNameByUid, String variableName, String operator) {
        StringBuilder cmdValue = new StringBuilder();
        cmdValue.append("IF ");
        cmdValue.append(variableNameByUid + " ");
        cmdValue.append(operator + " ");
        cmdValue.append(variableName + " ");
        cmdValue.append("(echo true) ELSE (echo false)");
        return cmdValue.toString();
    }

    private String getVariableNameByUid() {
        String varType;
        return (switch (varType = this.getVarType()) {
            case ITEM -> {
                Optional<String> itemVariableName = this.getItemVariableName();
                yield itemVariableName.map(variable -> this.zenaVariablesHandler.convertToCtmVariableName((String)variable));
            }
            case PROCESS -> Optional.ofNullable(this.zenaVariablesHandler.convertToCtmVariableName(this.getVariableNameFromParent()));
            case SYSTEM -> {
                XmlElement variableElement = XmlElement.ofNullable((Element)this.entitiesDefinitionsManager.getElementByTypeAndID("VARIABLE", this.getVariableUid()));
                Optional<String> zenaVariable = Optional.ofNullable(variableElement.getAttribute("NAME")).filter(s -> !s.isEmpty());
                yield zenaVariable.map(variable -> this.zenaVariablesHandler.annotateSystemVariableName("SYSTEM.VARIABLE." + variable));
            }
            default -> Optional.empty();
        }).orElse(VARIABLE_NOT_FOUND);
    }

    private Optional<String> getItemVariableName() {
        String itemUid = this.getVariableItemUid();
        String variableUid = this.getVariableUid();
        Optional<XmlElement> processItem = ZenaXmlUtils.getItemDefinition(this.taskDefinition, itemUid);
        List<XmlElement> variablesFromDefinition = ZenaXmlUtils.getVariablesFromDefinition(processItem, this.entitiesDefinitionsManager);
        return this.getVariableNameByUid(variablesFromDefinition, variableUid).map(variableName -> itemUid + "_" + variableName);
    }

    private Optional<String> getVariableNameByUid(List<XmlElement> variablesFromDefinition, String variableUid) {
        return variablesFromDefinition.stream().filter(variable -> variable.getAttribute("UID").equals(variableUid)).map(variable -> variable.getAttribute("NAME")).findFirst();
    }

    private String getVariableNameFromParent() {
        XmlElement itemsElement = this.taskDefinition.getParent();
        XmlElement processElement = itemsElement.getParent();
        XmlElement variables = Optional.ofNullable(processElement.getFirstChildElementByName("VARIABLES")).orElse(this.issueWarningMessage());
        return variables.getAllDirectchildsElement().stream().filter(variable -> variable.getAttribute("UID").equals(this.getVariableUid())).findFirst().map(variable -> variable.getAttribute("NAME")).orElse(VARIABLE_NOT_FOUND);
    }

    private XmlElement issueWarningMessage() {
        return XmlElement.nullXmlElement;
    }

    private String getVarType() {
        return this.taskDefinition.getFirstChildElementByName("ATTRIBUTES").getValueOfFirstChildElementByName("VARTYPE");
    }

    private String getVarDependencyValue() {
        return this.taskDefinition.getFirstChildElementByName("ATTRIBUTES").getValueOfFirstChildElementByName("VALUE");
    }

    private String getVariableUid() {
        return this.taskDefinition.getFirstChildElementByName("ATTRIBUTES").getValueOfFirstChildElementByName("UID");
    }

    private String getVariableItemUid() {
        return this.taskDefinition.getFirstChildElementByName("ATTRIBUTES").getValueOfFirstChildElementByName("ITEM_UID");
    }

    private String getOperator() {
        String operatorValue = this.taskDefinition.getFirstChildElementByName("ATTRIBUTES").getValueOfFirstChildElementByName("OPERATOR");
        return this.operatorMap.get(operatorValue);
    }

    @Override
    public String getControlMTaskType() {
        return "Command";
    }
}

