/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.zena.CommandLineParser;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.StartDirHandler;
import com.bmc.ctmconvert.zena.tasktypes.ExitCodeConverter;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SystemCommandTask
extends ZenaTask {
    public SystemCommandTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
    }

    @Override
    public String getControlMTaskType() {
        return "Command";
    }

    private void convertSYSCMDTask(ZenaJob job) {
        NodeList parametersNode;
        String cmdLine = this.getCmdLine();
        Optional<String> memlib = Optional.empty();
        NodeList memlibNode = this.getEntityAttributes().getElementsByTagName("START_DIR");
        if (memlibNode.getLength() > 0) {
            String startDir = memlibNode.item(0).getTextContent();
            cmdLine = StartDirHandler.addStartDirToCommand(startDir, cmdLine);
            memlib = Optional.of(startDir);
        }
        if ((parametersNode = this.getEntityAttributes().getElementsByTagName("PARAMETERS")).getLength() > 0) {
            String parameters = parametersNode.item(0).getTextContent();
            cmdLine = CommandLineParser.parse(cmdLine, parameters, job);
        }
        memlib.ifPresent(x$0 -> super.setMemLib((String)x$0));
        super.setCmdLine(cmdLine);
        new ExitCodeConverter(job, this.getEntityDefinition()).convert();
    }

    private String getCmdLine() {
        String cmdLine = "";
        NodeList cmdLineNode = this.getEntityAttributes().getElementsByTagName("COMMAND");
        if (cmdLineNode.getLength() > 0) {
            cmdLine = cmdLineNode.item(0).getTextContent();
        }
        cmdLine = cmdLine.replaceAll("[\\r\\n]", "").trim();
        if ((cmdLine = cmdLine.replaceAll("^\"(.*)\"$", "$1").trim()).contains(" ")) {
            cmdLine = String.format("\"%s\"", cmdLine);
        }
        return cmdLine;
    }

    @Override
    protected void convertTaskType() {
        this.convertSYSCMDTask(this.job);
    }
}

