/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SftpParametersConverter {
    public static final String CTM_HOME_FOLDER = "/";
    public static final String OP_COUNT = "OP_COUNT";
    private final XmlElement definition;
    private List<XmlElement> localDirVariables;
    private List<XmlElement> remoteDirVariables;
    private int operationCount;

    public SftpParametersConverter(XmlElement definition) {
        this.definition = definition;
        this.parseParameters();
    }

    public boolean isSupported() {
        return this.operationCount < 3;
    }

    public String getLocalPath() {
        return this.localDirVariables.stream().map(XmlElement::getText).filter(localDir -> !localDir.isEmpty()).collect(Collectors.joining(CTM_HOME_FOLDER));
    }

    public String getRemotePath() {
        String remotePath = this.remoteDirVariables.stream().map(XmlElement::getText).filter(remoteDir -> !remoteDir.isEmpty()).collect(Collectors.joining(CTM_HOME_FOLDER));
        return remotePath.isEmpty() ? CTM_HOME_FOLDER : remotePath;
    }

    private void parseParameters() {
        List<XmlElement> variables = this.getVariables();
        this.localDirVariables = this.getSortedVariablesBy(variables, "LOCALDIR");
        this.remoteDirVariables = this.getSortedVariablesBy(variables, "REMOTEDIR");
        this.operationCount = this.getOperationCount();
    }

    private List<XmlElement> getSortedVariablesBy(List<XmlElement> variables, String xmlTag) {
        return variables.stream().filter(this.startsWith(xmlTag)).sorted(Comparator.comparing(variable -> variable.getAttribute("ORDER"))).collect(Collectors.toList());
    }

    private int getOperationCount() {
        List op = this.definition.getAllDecnedElementByName(OP_COUNT);
        return op.stream().map(XmlElement::getText).map(Integer::parseInt).findFirst().orElse(0);
    }

    private Predicate<XmlElement> startsWith(String type) {
        return variable -> variable.getAttribute("NAME").startsWith(type);
    }

    private List<XmlElement> getVariables() {
        return this.definition.getAllDecnedElementByName("VARIABLE");
    }

    public Optional<String> getOperation() {
        return this.remoteDirVariables.stream().map(variable -> variable.getAttribute("OPERATION")).reduce((left, right) -> right);
    }
}

