/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class SapTask
extends ZenaTask {
    private final XmlElement attributes;
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;
    private final XmlElement xmlElement;

    public SapTask(Element entityDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefinition, job);
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.attributes = new XmlElement(this.getEntityAttributes());
        this.xmlElement = new XmlElement(this.getEntityDefinition());
    }

    @Override
    protected void convertTaskType() {
        this.convertJobAttributes();
        this.addDefaultSapAttributes();
        this.convertSapAttributes();
    }

    private void addDefaultSapAttributes() {
        this.job.addAutoEdits("%%SAPR3-JOBNAME", this.getSapJobName());
        this.job.addAutoEdits("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.job.addAutoEdits("%%SAPR3-JOB_COUNT", "FIRST_SCHEDULED");
        this.job.addAutoEdits("%%SAPR3-JOBCOUNT", "FIRST_SCHEDULED");
        this.job.addAutoEdits("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.job.addAutoEdits("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.job.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        this.job.addAutoEdits("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.job.addAutoEdits("%%SAPR3-DETECT_OPTION", "1");
        this.job.addAutoEdits("%%SAPR3-INC_APP_STAT", "no");
        this.job.addAutoEdits("%%SAPR3-RERUN_STEP_NUM", "1");
        this.job.addAutoEdits("%%SAPR3-RECIP_TYPE", "B");
        this.job.addAutoEdits("%%SAPR3-RECIP_COPY", "N");
        this.job.addAutoEdits("%%SAPR3-RECIP_BLIND_COPY", "N");
        this.job.addAutoEdits("%%SAPR3-RECIP_EXPRESS", "N");
        this.job.addAutoEdits("%%SAPR3-RECIP_NO_FORWARDING", "N");
        this.job.addAutoEdits("%%SAPR3-RERUN_FROM_POF", "N");
        this.job.addAutoEdits("%%SAPR3-JOB_WAIT_CHILD", "N");
        this.job.addAutoEdits("%%SAPR3-JOB_STATUS_CHILD", "N");
    }

    private void convertSapAttributes() {
        this.job.addAutoEdits("%%SAPR3-JOBNAME", this.getSapJobName());
        this.job.addAutoEdits("%%SAPR3-JOB_MODE", this.getSapJobMode());
        this.job.addAutoEdits("%%SAPR3-SUBMIT_ASAP", this.getSapStartType());
        this.job.addAutoEdits("%%SAPR3-JOBCLASS", this.getPriority());
        this.job.addAutoEdits("%%SAPR3-START_STEP", this.getJobCount());
        this.job.addAutoEdits("%%SAPR3-ACCOUNT", this.getSapLogin());
        this.convertSteps();
    }

    private String getSapLogin() {
        Optional<String> loginUid = this.xmlElement.getAllDecnedElementByName("LOGIN").stream().findFirst().map(login -> login.getAttribute("UID"));
        Optional<String> loginName = loginUid.map(uid -> this.entitiesDefinitionsManager.getElementByTypeAndID("LOGIN", (String)uid)).map(loginItem -> loginItem.getAttribute("NAME"));
        return loginName.orElse("DEFAULT_ACCOUNT");
    }

    private String getJobCount() {
        return this.getAttributeOrDefault("JOB_COUNT", "0");
    }

    private String getPriority() {
        return this.getAttributeOrDefault("PRIORITY", "C");
    }

    private String getSapStartType() {
        UnaryOperator calculateAsap = input -> {
            if (input.equalsIgnoreCase("IMMEDIATE")) {
                return "N";
            }
            return "X";
        };
        return this.getAttributeOrDefault("START_TYPE", "X", calculateAsap);
    }

    private void convertSteps() {
        XmlElement schema = XmlLoader.from((String)this.getAttribute("SCHEMA"));
        List<Step> steps = schema.getFirstChildElementByName("steps").getAllDirectchildsElement().stream().map(Step::new).collect(Collectors.toList());
        steps.forEach(step -> {
            int i = step.sequence();
            this.addDefaultSapStepAttributes(i);
            this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PROGRAM".formatted(i), step.program());
            this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-STEP_TYPE".formatted(i), step.type());
            this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-VAR-NAME".formatted(i), step.variantName());
        });
    }

    private void addDefaultSapStepAttributes(int index) {
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_COPIES".formatted(index), "1");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID".formatted(index), "X");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION".formatted(index), "8");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_BANNER".formatted(index), "D");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER".formatted(index), "D");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_IMMED".formatted(index), "N");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES".formatted(index), "-1");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS".formatted(index), "-1");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE".formatted(index), "Print");
        this.job.addAutoEdits("%%%%SAPR3-STEP-S%02d-VAR_TYPE".formatted(index), "REG");
    }

    private String getAttribute(String attribute) {
        return this.getAttributeOrDefault(attribute, "");
    }

    private String getAttributeOrDefault(String attribute, String defaultValue) {
        return this.getAttributeOrDefault(attribute, defaultValue, UnaryOperator.identity());
    }

    private <T> T getAttributeOrDefault(String attribute, T defaultValue, Function<String, T> transformer) {
        String value = this.attributes.getValueOfFirstChildElementByName(attribute);
        if (value.isEmpty()) {
            return defaultValue;
        }
        return transformer.apply(value);
    }

    private String getSapJobMode() {
        return this.getAttributeOrDefault("CREATE_JOB", "CREATE");
    }

    private String getSapJobName() {
        return this.getAttribute("NAME");
    }

    private void convertJobAttributes() {
        this.job.addAttribute("TASKTYPE", "Job");
        Globs.SAP_TYPE_FORM_VERSION.forEach(this.job::addAttribute);
    }

    @Override
    public String getControlMTaskType() {
        return "Job";
    }

    private static class Step {
        private final XmlElement data;

        public Step(XmlElement data) {
            this.data = data;
        }

        public String program() {
            return this.data.getAttribute("program");
        }

        public int sequence() {
            return GlobalFunctions.getNumberFrom((String)this.data.getAttribute("sequence")).orElse(1);
        }

        public String type() {
            String type = this.data.getAttribute("type").toUpperCase();
            if (type.contains("ABAP")) {
                return "A";
            }
            if (type.contains("COMMAND")) {
                return "C";
            }
            return "E";
        }

        public String variantName() {
            return this.data.getAttribute("variant_name");
        }
    }
}

