/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.BaseFtpTask;
import com.bmc.ctmconvert.zena.tasktypes.SftpParametersConverter;
import org.w3c.dom.Element;

public class SFtpTask
extends BaseFtpTask {
    private final SftpParametersConverter parameterConverter;

    public SFtpTask(Element entityDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefinition, job, entitiesDefinitionsManager);
        this.parameterConverter = new SftpParametersConverter(XmlElement.ofNullable((Element)entityDefinition));
        this.issueUnsupportedMessageIfNeeded(job);
    }

    private void issueUnsupportedMessageIfNeeded(ZenaJob job) {
        if (!this.parameterConverter.isSupported()) {
            job.addMessageWithJobNameAndOriginalJobName("WRN15042", new String[0]);
        }
    }

    @Override
    protected boolean isSupported() {
        return this.parameterConverter.isSupported();
    }

    @Override
    protected String getLeftPath(ZenaJob job) {
        String localPath = this.parameterConverter.getLocalPath();
        return job.getZenaVariablesHandler().annotateVariables(localPath);
    }

    @Override
    protected BaseFtpTask.FTP_COMMAND getFileTransferAction(ZenaJob job) {
        return this.parameterConverter.getOperation().map(BaseFtpTask.FTP_COMMAND::from).orElse(BaseFtpTask.FTP_COMMAND.UNKNOWN);
    }

    @Override
    protected String getRightPath() {
        String remotePath = this.parameterConverter.getRemotePath();
        return this.job.getZenaVariablesHandler().annotateVariables(remotePath);
    }
}

