/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EmailTask
extends ZenaTask {
    public EmailTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
    }

    private void createEmailTask() {
        String cmdLine = "echo \"sending mail\"";
        Properties onStmt = new Properties();
        onStmt.setProperty("ACTION", "DOMAIL");
        onStmt.setProperty("CODE", "*");
        onStmt.setProperty("STMT", "*");
        String dest = this.getEntityAttributes().getElementsByTagName("RECIPIENT").item(0).getTextContent().replace(",", ";");
        if (dest.length() > 255) {
            Reporter.addMessage(this.job.getMessages(), (String)"WRN15017", (String)this.job.getTablePathForSons(), (String[])new String[0]);
        }
        onStmt.setProperty("DEST", this.zenaVariablesHandler.annotateVariables(dest));
        String subject = "";
        Node subjectNode = this.getEntityAttributes().getElementsByTagName("SUBJECT").item(0);
        if (subjectNode != null) {
            subject = this.validateSpecialsCharacter(subjectNode.getTextContent(), this.job);
        }
        onStmt.setProperty("SUBJECT", this.zenaVariablesHandler.annotateVariables(subject));
        String message = "";
        Node messageTextNode = this.getEntityAttributes().getElementsByTagName("MESSAGE").item(0);
        if (messageTextNode != null) {
            message = this.validateSpecialsCharacter(messageTextNode.getTextContent(), this.job);
        }
        onStmt.setProperty("MESSAGE", FieldValidation.instance().validateAndReturnFixedValue("MAIL_MESSAGE", this.zenaVariablesHandler.annotateVariables(message)));
        onStmt.setProperty("URGENCY", "R");
        onStmt.setProperty("ATTACH_SYSOUT", "No");
        super.setCmdLine(cmdLine);
        super.setOnStatements(onStmt);
    }

    private String validateSpecialsCharacter(String text, ZenaJob job) {
        char leftSingleQuotes = '\u2018';
        char rightSingleQuotes = '\u2019';
        char minus = '\u2013';
        text = text.replace(leftSingleQuotes, '\'');
        text = text.replace(rightSingleQuotes, '\'');
        text = text.replace(minus, '-');
        Object specialsChars = "";
        for (char c : text.toCharArray()) {
            if (Integer.valueOf(c) <= 256) continue;
            specialsChars = (String)specialsChars + c;
        }
        if (!((String)specialsChars).isEmpty()) {
            Reporter.addMessage(job.getMessages(), (String)"WRN15014", (String)job.getTablePathForSons(), (String[])new String[0]);
            text = text.replaceAll("[" + (String)specialsChars + "]", "");
        }
        return text;
    }

    @Override
    public String getControlMTaskType() {
        return "Command";
    }

    @Override
    protected void convertTaskType() {
        this.createEmailTask();
    }
}

