/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class UnsupportedZenaVariables {
    private static final Pattern ITEM_VARIABLE_PATTERN = Pattern.compile("^ITEMS\\.(.*?)\\.VARIABLE\\.(.*?)");
    public static final Pattern SUPPORTED_EVENT_VARIABLE_PATTERN = Pattern.compile("^EVENT\\.ATTRIBUTE\\.(FILENAME|FILEPATH|FULLFILENAME|TARGET_PATH|SOURCE_PATH|SOURCE_FILEMASK|OPERATION|JOBNAME)", 2);
    public static final boolean UNKNOWN_TYPE = false;

    public boolean isSupportedVariable(String variableName) {
        if (this.isSupportedSuffix(variableName)) {
            if (this.isItemVariable(variableName)) {
                return this.isSupportedItemVariable(variableName);
            }
            if (this.isProcessVariable(variableName)) {
                return this.isSupportedProcessVariable(variableName);
            }
            if (this.isSystemVariable(variableName)) {
                return this.isSupportedSystemVariable(variableName);
            }
            if (this.isTaskVariable(variableName)) {
                return this.isSupportedTaskVariable(variableName);
            }
            if (this.isActionVariable(variableName)) {
                return false;
            }
            if (this.isReportVariable(variableName)) {
                return false;
            }
            if (this.isAgentVariable(variableName)) {
                return false;
            }
            if (this.isEventVariable(variableName)) {
                return this.isSupportedEventVariable(variableName);
            }
            return this.isDependencyVariable(variableName);
        }
        return false;
    }

    public boolean isDependencyVariable(String variableName) {
        return this.variableStartWith(variableName, "DEPENDENCY.VARIABLE");
    }

    private boolean isSupportedEventVariable(String variableName) {
        Matcher matcher = SUPPORTED_EVENT_VARIABLE_PATTERN.matcher(variableName);
        return matcher.matches();
    }

    public boolean isStartingWithZenaVariablePrefix(String variableName) {
        return this.isProcessVariable(variableName) || this.isItemVariable(variableName) || this.isSystemVariable(variableName) || this.isTaskVariable(variableName) || this.isEventVariable(variableName) || this.isAgentVariable(variableName) || this.isReportVariable(variableName) || this.isActionVariable(variableName) || this.isDependencyVariable(variableName);
    }

    private boolean isEventVariable(String variableName) {
        return this.variableStartWith(variableName, "EVENT.");
    }

    private boolean isActionVariable(String variableName) {
        return this.variableStartWith(variableName, "ACTION.");
    }

    private boolean isSupportedTaskVariable(String variableName) {
        return this.variableStartWith(variableName, "TASK.VARIABLE");
    }

    private boolean isTaskVariable(String variableName) {
        return this.variableStartWith(variableName, "TASK.");
    }

    private boolean isAgentVariable(String variableName) {
        return this.variableStartWith(variableName, "AGENT.");
    }

    private boolean isReportVariable(String variableName) {
        return this.variableStartWith(variableName, "REPORT.");
    }

    private boolean isSupportedSystemVariable(String variableName) {
        return this.variableStartWith(variableName, "SYSTEM.VARIABLE");
    }

    private boolean isSystemVariable(String variableName) {
        return this.variableStartWith(variableName, "SYSTEM.");
    }

    private boolean isSupportedProcessVariable(String variableName) {
        return this.variableStartWith(variableName, "PROCESS.VARIABLE");
    }

    private boolean isProcessVariable(String variableName) {
        return this.variableStartWith(variableName, "PROCESS.");
    }

    private boolean isSupportedItemVariable(String variableName) {
        Matcher matcher = ITEM_VARIABLE_PATTERN.matcher(variableName);
        return matcher.matches();
    }

    private boolean isSupportedSuffix(String variableName) {
        List<String> unsupportedProcessSuffixs = Arrays.asList(".ALIAS", ".DEF_ID", ".ENDED", ".ERROR_MSG", ".FOLDER", ".NAME.", ".OUTPUT", ".PRODUCTION_DATE", ".PRODUCTION_DAY", ".RUN_ID", ".START", ".STARTED", ".OWNER.DOMAIN", ".OWNER.EMAIL", ".OWNER.LOGIN", ".OWNER.NAME", ".OWNER.OTHER", ".OWNER.PHONE", ".CALENDARS.");
        Stream<String> suffixToRegex = unsupportedProcessSuffixs.stream().map(suffix -> "\\" + suffix + "$");
        boolean endsWithUnsupportedSuffix = suffixToRegex.anyMatch(variableName::matches);
        return !endsWithUnsupportedSuffix;
    }

    private boolean isItemVariable(String variableName) {
        return this.variableStartWith(variableName, "ITEMS.");
    }

    private boolean variableStartWith(String variableName, String prefix) {
        return variableName.startsWith(prefix);
    }
}

