/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.folders;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.folders.FolderNode;
import com.bmc.ctmconvert.zena.folders.FolderPath;
import com.bmc.ctmconvert.zena.folders.IFolderNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Document;

public class ZenaFolderHierarchy {
    private XmlElement document;
    private FolderCollection folderCollection = new FolderCollection(this);

    public ZenaFolderHierarchy(Document document) {
        this.document = XmlElement.fromDocument((Document)document);
    }

    public void createHierarchy() {
        List definitions = this.document.getAllDecnedElementByName("DEFINITION");
        for (XmlElement folderXmlElement : definitions) {
            String uid = this.getUid(folderXmlElement);
            String folderId = this.getFolderId(folderXmlElement);
            String name = this.getFolderName(folderXmlElement);
            Optional<String> parentUid = this.getParentId(folderXmlElement);
            FolderNode node = new FolderNode(name, folderId, uid, parentUid.orElse(""));
            this.folderCollection.add(node);
        }
    }

    public FolderPath getFolderPath(String folderId) {
        FolderPath folderPath = new FolderPath();
        IFolderNode node = this.folderCollection.getByFolderId(folderId);
        if (node != FolderNode.empty()) {
            return this.getFolderPath(node.getUid(), folderPath);
        }
        return folderPath;
    }

    private String getFolderId(XmlElement folderXmlElement) {
        return folderXmlElement.getAttribute("ID");
    }

    private String getUid(XmlElement folderXmlElement) {
        return folderXmlElement.getAttribute("UID");
    }

    private Optional<String> getParentId(XmlElement folderXmlElement) {
        XmlElement folder = folderXmlElement.getFirstChildElementByName("FOLDER");
        Optional<XmlElement> parentElement = Optional.ofNullable(folder.getFirstChildElementByName("PARENT"));
        Optional<String> parentUid = parentElement.map(parent -> this.getUid((XmlElement)parent));
        return parentUid;
    }

    private String getFolderName(XmlElement folderXmlElement) {
        XmlElement folderElement = folderXmlElement.getFirstChildElementByName("FOLDER");
        String folderName = folderElement.getAttribute("NAME");
        return folderName;
    }

    private FolderPath getFolderPath(String uid, FolderPath path) {
        IFolderNode node = this.folderCollection.getByUid(uid);
        if (node != FolderNode.empty()) {
            path.add(node);
        }
        if (!node.hasParent()) {
            return path;
        }
        return this.getFolderPath(node.getParentUid(), path);
    }

    private class FolderCollection {
        private Map<String, IFolderNode> uidToFolderNode = new HashMap<String, IFolderNode>();
        private Map<String, String> folderIdToUid = new HashMap<String, String>();

        public FolderCollection(ZenaFolderHierarchy zenaFolderHierarchy) {
        }

        public void add(IFolderNode node) {
            if (!node.equals(FolderNode.empty())) {
                this.folderIdToUid.put(node.getFolderId(), node.getUid());
                this.uidToFolderNode.put(node.getUid(), node);
            }
        }

        public IFolderNode getByUid(String uid) {
            return this.uidToFolderNode.getOrDefault(uid, FolderNode.empty());
        }

        public IFolderNode getByFolderId(String folderId) {
            Optional<String> uid = Optional.ofNullable(this.folderIdToUid.get(folderId));
            return uid.map(this::getByUid).orElse(FolderNode.empty());
        }
    }
}

