/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.events;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.events.event_directory.EventDirectoryData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public class ZenaEvents {
    private Map<String, EventDirectoryData> eventDirectories;
    private XmlElement document;

    public ZenaEvents(Document document) {
        this.document = XmlElement.fromDocument((Document)document);
        this.eventDirectories = this.createEventDirectories();
    }

    public Collection<EventDirectoryData> getEventDirectories() {
        return this.eventDirectories.values();
    }

    public EventDirectoryData getEventDirectoryById(String uid) {
        return this.eventDirectories.getOrDefault(uid, EventDirectoryData.emptyEvent);
    }

    private Map<String, EventDirectoryData> createEventDirectories() {
        List definitions = this.document.getAllDecnedElementByName("DEFINITION");
        return definitions.stream().map(eventXmlElement -> this.toEventDirectory((XmlElement)eventXmlElement)).filter(event -> !event.getUid().isEmpty()).collect(Collectors.toMap(event -> event.getUid(), event -> event));
    }

    private EventDirectoryData toEventDirectory(XmlElement eventXmlElement) {
        String eventType = this.getEventType(eventXmlElement);
        String uid = this.getEventUid(eventXmlElement);
        if (eventType.equals("EVENT_DIRECTORY")) {
            return this.createDirectoryEvent(eventXmlElement, uid);
        }
        return EventDirectoryData.emptyEvent;
    }

    private EventDirectoryData createDirectoryEvent(XmlElement eventXmlElement, String uid) {
        XmlElement attributes = eventXmlElement.getAllDecnedElementByName("ATTRIBUTES").stream().findFirst().orElse(XmlElement.nullXmlElement);
        EventDirectoryData eventDirectory = new EventDirectoryData();
        eventDirectory.setUid(uid);
        eventDirectory.setOperation(attributes.getValueOfFirstChildElementByName("OPERATION"));
        eventDirectory.setSourceFilemask(attributes.getValueOfFirstChildElementByName("SOURCE_FILEMASK"));
        eventDirectory.setSourcePath(attributes.getValueOfFirstChildElementByName("SOURCE_PATH"));
        eventDirectory.setTargetPath(attributes.getValueOfFirstChildElementByName("TARGET_PATH"));
        eventDirectory.setWriteover(attributes.getValueOfFirstChildElementByName("WRITEOVER"));
        String jobName = eventXmlElement.getFirstChildElementByName("EVENT_DIRECTORY").getAttribute("NAME");
        eventDirectory.setEventJobName(jobName);
        eventDirectory.setEventXmlElement(eventXmlElement);
        eventDirectory.setCyclicIntervalSeconds(attributes.getValueOfFirstChildElementByName("POLL_INTERVAL"));
        return eventDirectory;
    }

    private String getEventUid(XmlElement eventXmlElement) {
        return eventXmlElement.getAttribute("UID");
    }

    private String getEventType(XmlElement eventXmlElement) {
        List allDirectchildElements = eventXmlElement.getAllDirectchildsElement();
        return allDirectchildElements.stream().findFirst().map(elem -> elem.getTagName()).orElse("");
    }
}

