/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.events;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProcessDetails {
    private final String name;
    private final XmlElement data;

    public ProcessDetails(XmlElement data) {
        this(ProcessDetails.getJobName(data), data);
    }

    private static String getJobName(XmlElement data) {
        return ZenaDefs.getSmartTableName(data.getElement());
    }

    public ProcessDetails(String name, XmlElement data) {
        this.name = name;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public XmlElement getData() {
        return this.data;
    }

    public String getUid() {
        return this.getData().getAttribute("UID");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessDetails other = (ProcessDetails)obj;
        if (this.data == null ? other.data != null : !this.data.equals((Object)other.data)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    List<Pair<String, String>> getProcessVariables() {
        return ZenaXmlUtils.getVariablesFrom(this.data, variable -> new Pair((Object)variable.getAttribute("UID"), (Object)variable.getAttribute("NAME")));
    }

    List<Pair<String, String>> getPolicyVariables() {
        XmlElement policy = Optional.ofNullable(this.data.getFirstChildElementByName("POLICIES")).map(policies -> policies.getFirstChildElementByName("POLICY")).orElse(XmlElement.nullXmlElement);
        return ZenaXmlUtils.getVariablesFrom(policy, variable -> new Pair((Object)variable.getAttribute("UID"), (Object)variable.getText()));
    }

    public List<Pair<String, String>> getVariables() {
        List<Pair<String, String>> processVariables = this.getProcessVariables();
        return this.getPolicyVariables().stream().map(variable -> this.mapByUid((Pair<String, String>)variable, processVariables)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Pair<String, String> mapByUid(Pair<String, String> policyVariable, List<Pair<String, String>> processVariables) {
        return processVariables.stream().filter(x -> ((String)x.getKey()).equals(policyVariable.getKey())).findFirst().map(x -> new Pair((Object)((String)x.getValue()), (Object)((String)policyVariable.getValue()))).orElse(null);
    }
}

