/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.events;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.events.ProcessDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class EventProcessRelation {
    private static final String REF_UID = "REF_UID";
    private final Map<String, Collection<ProcessDetails>> eventRefUidToProcessDetails = new HashMap<String, Collection<ProcessDetails>>();
    private final Map<String, Set<String>> processUidToEventUids = new HashMap<String, Set<String>>();
    private final Set<String> uniqueEvents = new HashSet<String>();

    public Collection<ProcessDetails> getProcessDetailsByEventUid(String eventUid) {
        return this.eventRefUidToProcessDetails.getOrDefault(eventUid, Collections.emptyList());
    }

    public Collection<String> getEventUidsByProcessUid(String processUid) {
        return this.processUidToEventUids.getOrDefault(processUid, Collections.emptySet());
    }

    public List<String> getAllProcessTriggeredByEvent() {
        return new ArrayList<String>(this.processUidToEventUids.keySet());
    }

    public void addProcess(Element process) {
        XmlElement definitionXmlElement = XmlElement.ofNullable((Element)process);
        XmlElement processDefinitions = definitionXmlElement.getFirstChildElementByName("PROCESS");
        Optional<XmlElement> processXmlElement = Optional.ofNullable(processDefinitions);
        processXmlElement.ifPresent(prcssElem -> {
            String processUid = this.getProcessUid((XmlElement)prcssElem);
            List<String> eventRefUids = this.getEventReferenceUid((XmlElement)prcssElem);
            List<String> uniqueEvents = eventRefUids.stream().filter(this::isUniqueEvent).collect(Collectors.toList());
            this.addProcessToEvent(processUid, uniqueEvents);
            eventRefUids.forEach(eventRef -> this.addEventToProcess((String)eventRef, new ProcessDetails((XmlElement)prcssElem)));
        });
    }

    private void addProcessToEvent(String processUid, List<String> eventRefUids) {
        if (!eventRefUids.isEmpty()) {
            Set eventUids = this.processUidToEventUids.getOrDefault(processUid, new HashSet());
            eventUids.addAll(eventRefUids);
            this.processUidToEventUids.put(processUid, eventUids);
        }
    }

    private boolean isUniqueEvent(String eventUid) {
        return this.uniqueEvents.add(eventUid);
    }

    private String getProcessUid(XmlElement processElement) {
        return processElement.getAttribute("UID");
    }

    private void addEventToProcess(String eventRefUid, ProcessDetails process) {
        Collection<ProcessDetails> processNames;
        if (!this.eventRefUidToProcessDetails.containsKey(eventRefUid)) {
            this.eventRefUidToProcessDetails.put(eventRefUid, new ArrayList());
        }
        if (!this.containsProcessDetails(processNames = this.eventRefUidToProcessDetails.get(eventRefUid), process)) {
            processNames.add(process);
        }
    }

    private boolean containsProcessDetails(Collection<ProcessDetails> list, ProcessDetails item) {
        return list.stream().anyMatch(o -> o.getName().equals(item.getName()));
    }

    private List<String> getEventReferenceUid(XmlElement processXmlElement) {
        List policies = processXmlElement.getAllDecnedElementByName("POLICY");
        return policies.stream().map(policy -> policy.getAttribute(REF_UID)).filter(policyRefId -> !policyRefId.isEmpty()).collect(Collectors.toList());
    }
}

