/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.ConditionsGenerator;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.SchedulingConverter;
import com.bmc.ctmconvert.zena.ZenaActions;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.events.EventProcessRelation;
import com.bmc.ctmconvert.zena.events.ZenaEvents;
import com.bmc.ctmconvert.zena.events.event_directory.EventDirectoryData;
import com.bmc.ctmconvert.zena.handlers.EnableFlagHandler;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZenaDefs
implements SourceDefinitions {
    private static final String ENTITY_TYPE = "TYPE";
    private static Map<String, String> uid2name = new HashMap<String, String>();
    private static UniqueValueGenerator uniqueValue = new UniqueValueGenerator();
    private final ArrayList<String> messages = new ArrayList();
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;
    private final RulesDataSet rules;
    private AttrHolderList top_level_parents;

    public ZenaDefs() {
        this(RuleManager.instance().getCurrentRules(), EntitiesDefinitionsManager.instance());
    }

    public ZenaDefs(RulesDataSet rules, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        RBC.initAnonymousCount();
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        XmlElement agentsXmlElement = this.getAgentXmlElement("Agents.xml");
        XmlElement agentListXmlElement = this.getAgentXmlElement("AgentList.xml");
        ZenaActions zenaAgentList = new ZenaActions(agentsXmlElement, agentListXmlElement, this.messages);
        Map<String, Collection<ZenaActions.Agent>> agentsActions = zenaAgentList.getAgentsActions();
        this.writeAgentsActions(agentsActions);
        this.rules = rules;
        entitiesDefinitionsManager.initializeGlobalVariables();
    }

    public static String getUniqueTableName(String uid, String name) {
        return uid2name.computeIfAbsent(uid, ignore -> uniqueValue.getUniqueValue("TABLE_NAME", name, 64));
    }

    public static String getSmartTableName(Element entityDefinition) {
        String processUID = entityDefinition.getAttribute("UID");
        String name = ZenaDefs.extractJobName(entityDefinition);
        return ZenaDefs.getUniqueTableName(processUID, name);
    }

    public static boolean isOrderingJobRuleEnabled(RulesDataSet rules) {
        return rules.getStringRule("Zena rules", new String[]{"SUB_PROCESS_2_ORDERING_JOB"}).equals("CONVERT_TO_CTMORDER");
    }

    public static boolean addZenaItemUidOnlyWhenNeeded(RulesDataSet rules) {
        return rules.getBooleanRule("Zena rules", new String[]{"ALWAYS_ADD_ITEM_UID_PREFIX_TO_ITEM_VARIABLE_NAMES"}) == false;
    }

    public static boolean shouldConvertTerminators(RulesDataSet rules) {
        boolean shouldConvertTerminators = rules.getBooleanRule("Zena rules", new String[]{"CONVERT_TERMINATOR"});
        return ZenaDefs.isOrderingJobRuleEnabled(rules) || shouldConvertTerminators;
    }

    public AttrHolderList getTopLevelEntities() {
        this.top_level_parents = new AttrHolderList();
        HashMap header = AttrHolder.buildHeadersMap((String)String.join((CharSequence)",", "UID", ENTITY_TYPE));
        Map<String, List<String>> processChildMap = EntitiesDefinitionsManager.instance().getProcessChildsMap();
        Collection<String> processesTriggeredByEvents = this.getProcessesTriggeredByEvents();
        processesTriggeredByEvents.forEach(evtFoldr -> this.top_level_parents.add((Object)new AttrHolder(new String[]{evtFoldr, "EVENT"}, header)));
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        for (String id : processChildMap.keySet()) {
            Element entity = EntitiesDefinitionsManager.instance().getElementByID(id);
            if (entity.hasAttribute("NAME")) {
                filterDetails.put("Name", entity.getAttribute("NAME"));
            }
            if (entity.hasAttribute("ALIAS")) {
                filterDetails.put("Alias", entity.getAttribute("ALIAS"));
            }
            if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
            this.top_level_parents.add((Object)new AttrHolder(new String[]{id, "PROCESS"}, (Map)header));
        }
        return this.filterDisabledEntities(this.top_level_parents, this.entitiesDefinitionsManager);
    }

    private Collection<String> getProcessesTriggeredByEvents() {
        EventProcessRelation eventProcessRelation = this.entitiesDefinitionsManager.getEventProcessRelation();
        return eventProcessRelation.getAllProcessTriggeredByEvent().stream().filter(processUid -> this.hasEvent((String)processUid, eventProcessRelation)).collect(Collectors.toSet());
    }

    private boolean hasEvent(String processUid, EventProcessRelation eventProcessRelation) {
        ZenaEvents events = this.entitiesDefinitionsManager.getEvents();
        Collection<String> eventUidsByProcessUid = eventProcessRelation.getEventUidsByProcessUid(processUid);
        return eventUidsByProcessUid.stream().anyMatch(eventId -> !EventDirectoryData.isEmptyEvent(events.getEventDirectoryById((String)eventId)));
    }

    AttrHolderList filterDisabledEntities(AttrHolderList topLevelEntities, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        if (this.shouldConvertDisabledTopLevelProcesses()) {
            return topLevelEntities;
        }
        return topLevelEntities.stream().filter(this.filterEnabledEntities(entitiesDefinitionsManager)).collect(Collectors.toCollection(AttrHolderList::new));
    }

    private boolean shouldConvertDisabledTopLevelProcesses() {
        return "CONVERT".equals(this.rules.getStringRule("Zena rules", new String[]{"DISABLED_PROCESSES"}));
    }

    private Predicate<IAttrHolder> filterEnabledEntities(EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return topLevelEntity -> {
            String entityUID = topLevelEntity.getAttr("UID");
            Element entityDefinition = entitiesDefinitionsManager.getElementByID(entityUID);
            EnableFlagHandler enableFlagHandler = new EnableFlagHandler(entityDefinition, entityDefinition);
            return enableFlagHandler.isEnabled();
        };
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public void finalize_() {
        CsvWriter writer = new CsvWriter(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "ZenaJobsStatistics.csv");
        try {
            String[] header = new String[]{"ID", "PARENT_NAME", "JOB_NAME", ENTITY_TYPE, "ZENA_INSTANCE_TYPE", "ZENA_TYPE", "CHIDREN", "HAS_SCHEDULING", "INSTANCE_COUNT"};
            writer.writeRecord(header);
            for (String[] row : ZenaJob.jobsStatistics.values()) {
                writer.writeRecord(row);
            }
            Document tasksDocument = EntitiesDefinitionsManager.instance().getDocumentByType("TASK");
            NodeList tasksList = tasksDocument.getElementsByTagName("DEFINITION");
            for (int index = 0; index < tasksList.getLength(); ++index) {
                Element task = (Element)((Element)tasksList.item(index)).getFirstChild().getNextSibling();
                String ID = task.getAttribute("UID");
                if (ZenaJob.jobsStatistics.containsKey(ID)) continue;
                writer.writeRecord(new String[]{ID, "", task.getAttribute("NAME"), "", "", task.getTagName(), "", "", "0"});
            }
            writer.close();
            ZenaJob.jobsStatistics.clear();
            uid2name.clear();
            uniqueValue = new UniqueValueGenerator();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        ConditionsGenerator.instance().writeZekeConditionsToFile();
        ConditionsGenerator.destroy();
        SchedulingConverter.destroy();
        EntitiesDefinitionsManager.destroy();
    }

    public static String extractJobName(Element element) {
        return ZenaDefs.extractJobName(element, null, null, null);
    }

    public static String extractJobName(Element element, String entityName, ArrayList<String> messages, String attr) {
        String name;
        if (entityName != null) {
            return entityName;
        }
        String elementID = element.getAttribute("UID");
        String origName = name = ZenaDefs.getOriginalName(element, elementID);
        name = name.replaceAll("\"", "");
        name = name.trim();
        name = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", name.replace(" ", "_"));
        if (name == null || name.isEmpty()) {
            name = elementID;
        }
        if (messages != null && !origName.equals(name)) {
            Reporter.addMessage(messages, (String)"INF15003", (String)name, (String[])new String[]{attr, "(" + element.getTagName() + " name)", origName, name});
        }
        return name;
    }

    public static String getOriginalName(Element element, String elementID) {
        Element elementDefinition;
        String name = element.getAttribute("ALIAS");
        if (name == null || name.isEmpty()) {
            name = element.getAttribute("NAME");
        }
        if (element.getTagName().equals("TASK_DEPENDENCY") && (elementDefinition = EntitiesDefinitionsManager.instance().getElementByID(elementID)) != null) {
            name = elementDefinition.getAttribute("NAME");
            if (elementDefinition.getTagName().equals("ZEKE")) {
                name = elementDefinition.getAttribute("JOBNAME");
            }
        }
        return name;
    }

    public void init() throws ConvertorCancelClickException {
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        String uid = attributes.getAttr("UID");
        String type = attributes.getAttr(ENTITY_TYPE);
        return new ZenaJob(uid, type);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return "UID";
    }

    public String getEntNameFieldName() {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        return false;
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return true;
    }

    public ArrayList<String> getGeneralMessages() {
        return this.messages;
    }

    private XmlElement getAgentXmlElement(String sourceFileName) {
        XmlElement agentFileElements = XmlElement.nullXmlElement;
        try {
            Path dataDir = FileSystems.getDefault().getPath(Params.instance().getDatasourcePath(), new String[0]);
            Path agentFile = dataDir.resolve(sourceFileName);
            InputStream agentOutputStream = Files.newInputStream(agentFile, new OpenOption[0]);
            agentFileElements = XmlLoader.from((InputStream)agentOutputStream);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return agentFileElements;
    }

    private void writeAgentsActions(Map<String, Collection<ZenaActions.Agent>> agentListUidToAgents) {
        agentListUidToAgents.forEach(this::writeAgentListToReporter);
    }

    private void writeAgentListToReporter(String agentListName, Collection<ZenaActions.Agent> agentList) {
        String validateAgentListName = FieldValidation.instance().validateAndReturnFixedValue("NODEGRP", agentListName);
        HashSet<String> nodes = new HashSet<String>();
        for (ZenaActions.Agent agent : agentList) {
            String validateAgentName = FieldValidation.instance().validateAndReturnFixedValue("NODEID", agent.getComputerName());
            nodes.add(validateAgentName);
        }
        if (!agentListName.isEmpty() && !nodes.isEmpty()) {
            Reporter.addNodeGroupAction((String)validateAgentListName, nodes, (String)validateAgentListName);
        }
    }
}

