/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace.utilties;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.draftwriter.DraftWriter;
import com.bmc.ctmconvert.common.draftwriter.json.JSONDraftWriter;
import com.bmc.ctmconvert.common.draftwriter.xml.XMLDraftWriter;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.convertor.Convertor;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.sourceDefinitions.GeneralSourceDefinitions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class WorkspaceWriter {
    private final IWorkspace workspace;
    private final DataAccumulator dataAccumulator;
    private final String projectTargetCTMVersion;

    public WorkspaceWriter(IWorkspace workspace, DataAccumulator dataAccumulator, String projectTargetCTMVersion) {
        this.workspace = workspace;
        this.dataAccumulator = dataAccumulator;
        this.projectTargetCTMVersion = projectTargetCTMVersion;
    }

    public void write(OutputStream output) throws ConvertorException, ConvertorCancelClickException, IOException {
        Convertor convertor = () -> {};
        GeneralSourceDefinitions sourceDefinitions = new GeneralSourceDefinitions(convertor, this.workspace);
        if (this.projectTargetCTMVersion != null) {
            Params.instance().setGUIVersion(this.projectTargetCTMVersion);
        }
        DraftWriter writer = this.getDraftWriter(sourceDefinitions);
        OutputStreamWriter streamWriter = new OutputStreamWriter(output);
        writer.writeDraft(streamWriter);
        streamWriter.close();
    }

    private DraftWriter getDraftWriter(SourceDefinitions sourceDefinitions) {
        if (SettingsBooleanKeys.JSON_DRAFT_FORMAT.isEnabled()) {
            return new JSONDraftWriter(sourceDefinitions, this.dataAccumulator);
        }
        return this.getXMLDraftWriter(sourceDefinitions);
    }

    private DraftWriter getXMLDraftWriter(SourceDefinitions sourceDefinitions) {
        DraftFormat draftFormat = new DraftFormat(FileUtils.getDraftCharset(), (jobIdForMessages, descriptionValue) -> descriptionValue);
        return new XMLDraftWriter(sourceDefinitions, this.dataAccumulator, draftFormat);
    }
}

